# 
# Run from PostgreSQL installation directory
#
#--------------------------------------------------------
rm *.out
rm *.ok
rm testprange.err
rm testprange_e.sql
#--------------------------------------------------------
rm tmp
echo "set enable_constraint_exclusion = false;" > tmp
cat tmp testprange_noset.sql > testprange.sql
rm tmp

bin/psql -a -f  testprangect.sql template1 > testprange0a_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t0a.ok 2>&1

bin/psql -a -f  testprangectinh0.sql template1 > testprange0b_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t0b.ok 2>&1

bin/psql -a -f  testprangectinh1.sql template1 > testprange1_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t1.ok 2>&1

bin/psql -a -f  testprangectinh2.sql template1 > testprange2_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t2.ok 2>&1

bin/psql -a -f  testprangectinh3.sql template1 > testprange3_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t3.ok 2>&1

bin/psql -a -f  testprangectinh4.sql template1 > testprange4_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t4.ok 2>&1

bin/psql -a -f  testprangectinh5.sql template1 > testprange5_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t5.ok 2>&1

#--------------------------------------------------------------------
rm tmp
echo "set enable_constraint_exclusion = true;" > tmp
cat tmp testprange_noset.sql > testprange.sql
rm tmp
sed -e 's/select/explain select/' testprange.sql > testprange_e.sql


echo "test0a: no inheritance"
bin/psql -a -f  testprangect.sql template1 > testprange0a_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t0a.out 2>&1
grep -v -i "SET" testprange_t0a.out > test_tmp.out
grep -v -i "SET" testprange_t0a.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

echo "test0b: inheritance, no constraints"
bin/psql -a -f  testprangectinh0.sql template1 > testprange0b_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t0b.out 2>&1
grep -v -i "SET" testprange_t0b.out > test_tmp.out
grep -v -i "SET" testprange_t0b.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

echo "test1: single range constraints"
bin/psql -a -f  testprangectinh1.sql template1 > testprange1_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t1.out 2>&1
grep -v -i "SET" testprange_t1.out > test_tmp.out
grep -v -i "SET" testprange_t1.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

bin/psql -a -f  testprange_e.sql template1 > test_explain.out 2>&1
cat test_explain.out | grep -i se > testprange_t1e.out
cat test_explain.out > testprange_fullexplain.out

echo "test2: double range constraints"
bin/psql -a -f  testprangectinh2.sql template1 > testprange2_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t2.out 2>&1
grep -v -i "SET" testprange_t2.out > test_tmp.out
grep -v -i "SET" testprange_t2.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

bin/psql -a -f  testprange_e.sql template1 > test_explain.out 2>&1
cat test_explain.out | grep -i se > testprange_t2e.out
cat test_explain.out >> testprange_fullexplain.out

echo "test3: list/IN constraints"
bin/psql -a -f  testprangectinh3.sql template1 > testprange3_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t3.out 2>&1
grep -v -i "SET" testprange_t3.out > test_tmp.out
grep -v -i "SET" testprange_t3.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

bin/psql -a -f  testprange_e.sql template1 > test_explain.out 2>&1
cat test_explain.out | grep -i se > testprange_t3e.out
cat test_explain.out >> testprange_fullexplain.out

echo "test4: mixed range and list/IN constraints"
bin/psql -a -f  testprangectinh4.sql template1 > testprange4_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t4.out 2>&1
grep -v -i "SET" testprange_t4.out > test_tmp.out
grep -v -i "SET" testprange_t4.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

bin/psql -a -f  testprange_e.sql template1 > test_explain.out 2>&1
cat test_explain.out | grep -i se > testprange_t4e.out
cat test_explain.out >> testprange_fullexplain.out

echo "test5: mixed no inference constraints"
bin/psql -a -f  testprangectinh5.sql template1 > testprange5_ct.out 2>&1
bin/psql -a -f  testprange.sql template1 > testprange_t5.out 2>&1
grep -v -i "SET" testprange_t5.out > test_tmp.out
grep -v -i "SET" testprange_t5.ok > test_tmp.ok
diff -c test_tmp.out test_tmp.ok >> testprange.err

bin/psql -a -f  testprange_e.sql template1 > test_explain.out 2>&1
cat test_explain.out | grep -i se > testprange_t5e.out
cat test_explain.out >> testprange_fullexplain.out

#-------------------------------
echo "errorfile wc=`cat testprange.err | wc`"
