/*
 *	Copyright 2024 Long 4 Core (mjbaars1977@gmail.com)
 *
 *	:set softtabstop=10
 */

#include	<math.h>
#include	<byteswap.h>

#include	"postgres.h"
#include	"fmgr.h"
#include	"utils/bytea.h"
#include	"utils/float.h"
#include	"utils/elog.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1	(cast_bytea_to_float8);
PG_FUNCTION_INFO_V1	(cast_float8_to_bytea);

	uint8_t		ret[12] =	{ 0x30, 0x00, 0x00, 0x00 };					// conform struct varlena in pgsql/server/c.h

Datum	cast_bytea_to_float8	(PG_FUNCTION_ARGS)
{
	uint8_t*		arg	        =	(uint8_t*)	PG_GETARG_BYTEA_P(0);		// most significant byte at lower  address
	float8		ret	        =	-NAN;

	elog(INFO, "arg[ 0]: %08X %02hhX", &arg[ 0], arg[ 0]);					// 4 bytes header, n bytes data (each byte counted as 4 bytes !?!)
	elog(INFO, "arg[ 1]: %08X %02hhX", &arg[ 1], arg[ 1]);
	elog(INFO, "arg[ 2]: %08X %02hhX", &arg[ 2], arg[ 2]);
	elog(INFO, "arg[ 3]: %08X %02hhX", &arg[ 3], arg[ 3]);
	elog(INFO, "arg[ 4]: %08X %02hhX", &arg[ 4], arg[ 4]);
	elog(INFO, "arg[ 5]: %08X %02hhX", &arg[ 5], arg[ 5]);
	elog(INFO, "arg[ 6]: %08X %02hhX", &arg[ 6], arg[ 6]);
	elog(INFO, "arg[ 7]: %08X %02hhX", &arg[ 7], arg[ 7]);
	elog(INFO, "arg[ 8]: %08X %02hhX", &arg[ 8], arg[ 8]);
	elog(INFO, "arg[ 9]: %08X %02hhX", &arg[ 9], arg[ 9]);
	elog(INFO, "arg[10]: %08X %02hhX", &arg[10], arg[10]);
	elog(INFO, "arg[11]: %08X %02hhX", &arg[11], arg[11]);

	if	((* (unsigned*) &arg[ 0]) == 0x00000030)

	(* (uint64_t*)     &ret    )	        =	bswap_64	(* (uint64_t*) &arg[ 4]);			// most significant byte at higher address

	else

	elog(ERROR, "cannot cast type bytea to float8");

	PG_RETURN_FLOAT8(ret);
}

Datum	cast_float8_to_bytea	(PG_FUNCTION_ARGS)
{
	float8		arg	        =	(float8)		PG_GETARG_FLOAT8(0);		// most significant byte at higher address

	(* (uint64_t*)     &ret[ 4])          =	bswap_64	(* (uint64_t*) &arg    );			// most significant byte at lower  address

	elog(INFO, "ret[ 0]: %08X %02hhX", &ret[ 0], ret[ 0]);
	elog(INFO, "ret[ 1]: %08X %02hhX", &ret[ 1], ret[ 1]);
	elog(INFO, "ret[ 2]: %08X %02hhX", &ret[ 2], ret[ 2]);
	elog(INFO, "ret[ 3]: %08X %02hhX", &ret[ 3], ret[ 3]);
	elog(INFO, "ret[ 4]: %08X %02hhX", &ret[ 4], ret[ 4]);
	elog(INFO, "ret[ 5]: %08X %02hhX", &ret[ 5], ret[ 5]);
	elog(INFO, "ret[ 6]: %08X %02hhX", &ret[ 6], ret[ 6]);
	elog(INFO, "ret[ 7]: %08X %02hhX", &ret[ 7], ret[ 7]);
	elog(INFO, "ret[ 8]: %08X %02hhX", &ret[ 8], ret[ 8]);
	elog(INFO, "ret[ 9]: %08X %02hhX", &ret[ 9], ret[ 9]);
	elog(INFO, "ret[10]: %08X %02hhX", &ret[10], ret[10]);
	elog(INFO, "ret[11]: %08X %02hhX", &ret[11], ret[11]);

	PG_RETURN_BYTEA_P (&ret);
}

