DO $$
DECLARE
    i int;
    nbranches int := 1;
    ntellers int := 10;
    naccounts int := 100000;
    scale int := 60;

    total_branches int := nbranches * scale;
    total_tellers int := ntellers * scale;
    total_accounts int := naccounts * scale;
    sql text;
BEGIN
    FOR i IN 0..14 LOOP
        -- Insert into pgbench_branches_X
        sql := format('INSERT INTO pgbench_branches_%s (bid, bbalance) SELECT bid, 0 FROM generate_series(1, %s) AS bid;',
                      i, total_branches);
        EXECUTE sql;

        -- Insert into pgbench_tellers_X
        sql := format('INSERT INTO pgbench_tellers_%s (tid, bid, tbalance) SELECT tid, ((tid - 1) / %s) + 1, 0 FROM generate_series(1, %s) AS tid;',
                      i, ntellers, total_tellers);
        EXECUTE sql;

        -- Insert into pgbench_accounts_X
        sql := format('INSERT INTO pgbench_accounts_%s (aid, bid, abalance, filler) SELECT aid, ((aid - 1) / %s) + 1, 0, '''' FROM generate_series(1, %s) AS aid;',
                      i, naccounts, total_accounts);
        EXECUTE sql;
    END LOOP;
END$$;

