#!/bin/bash

##################
### Definition ###
##################

## prefix
##PUB_PREFIX="/home/nisha/project/pg2/postgres/inst/bin"

## Used source
SOURCE=patched

## Number of runs
NUMRUN=3

## Measurement duration
DURATION=300

## Number of clients during a run
NUMCLIENTS=45

###########################
### measure performance ###
###########################

for i in `seq ${NUMRUN}`
do
    # Prepare clean enviroment for each measurements
    sh test2_setup_45c.sh $SOURCE

    echo "=================="
    echo "${SOURCE}_${i}.dat"
    echo "=================="

    ./pgbench -p 5433 -U postgres postgres -c $NUMCLIENTS -j $NUMCLIENTS -T $DURATION -f pgbench_script_45c.sql -n > pub_${SOURCE}_${i}.dat &
    ./pgbench -p 5434 -U postgres postgres -c $NUMCLIENTS -j $NUMCLIENTS -T $DURATION > sub_${SOURCE}_${i}.dat
done
