#!/bin/bash

port_pub=5433
port_sub=5434

##################
### Definition ###
##################

## prefix
##PUB_PREFIX="/home/nisha/project/pg2/postgres/inst/bin"

## scale factor
SCALE=60

## pgbench init command
#INIT_COMMAND="./pgbench -i -U postgres postgres -s $SCALE"

SOURCE=$1

################
### clean up ###
################

./pg_ctl stop -D data_pub -w
./pg_ctl stop -D data_sub -w
rm -rf data* *log

#######################
### setup publisher ###
#######################

./initdb -D data_pub -U postgres
cat << EOF >> data_pub/postgresql.conf
port=$port_pub
autovacuum = false
shared_buffers = '30GB'
max_wal_size = 20GB
min_wal_size = 10GB
wal_level = logical
max_replication_slots = 500
max_logical_replication_workers = 100
max_active_replication_origins = 500
max_wal_senders=500
max_worker_processes=1000 
max_replication_slots=500 
EOF

./pg_ctl -D data_pub start -w -l pub.log


## create 15 tables
./psql -U postgres -p  $port_pub -f pub_tables.sql

## intialize data in 15 tables
./psql -U postgres -p $port_pub -f pub_tables_insert.sql

## create 15 publications
./psql -U postgres -p $port_pub -f publications.sql

#######################
### setup sublisher ###
#######################

./initdb -D data_sub -U postgres

cat << EOF >> data_sub/postgresql.conf
port=$port_sub
autovacuum = false
shared_buffers = '30GB'
max_wal_size = 20GB
min_wal_size = 10GB
track_commit_timestamp = on
# log_min_messages = DEBUG1
max_replication_slots = 500
max_logical_replication_workers = 100
max_active_replication_origins = 500
max_wal_senders=500
max_worker_processes=1000 
max_replication_slots=500 
EOF

./pg_ctl -D data_sub start -w -l sub.log


## sub's own pgbench tables
./pgbench -i -p $port_sub -U postgres postgres -s $SCALE

## create the tables of publisher
./psql -U postgres -p $port_sub -f pub_tables.sql


## create 15 subscriptions
if [ $SOURCE = "head" ]
then
     ./psql -U postgres -p $port_sub -f subscriptions_head.sql
else
     ./psql -U postgres -p $port_sub -f subscriptions.sql
fi

# Wait until all the table sync is done
REMAIN="f"

while [ "$REMAIN" = "f" ]
do
    # Sleep a bit to avoid running the query too much
    sleep 1s

    # Check pg_subscription_rel catalog. This query is ported from wait_for_subscription_sync()
    # defined in Cluster.pm.
    REMAIN=`./psql -qtA -U postgres -p $port_sub -c "SELECT count(1) = 0 FROM pg_subscription_rel WHERE srsubstate NOT IN ('r', 's');"`

    # Print the result for the debugging purpose
    echo $REMAIN
done

./psql -U postgres -p $port_pub -c "VACUUM ANALYZE;"

sleep 5s
