-- Create pgbench_history_X tables
DO $$
DECLARE
    i int;
BEGIN
    FOR i IN 0..14 LOOP
        EXECUTE format('CREATE TABLE pgbench_history_%s (
                            tid int,
                            bid int,
                            aid bigint,
                            delta int,
                            mtime timestamp,
                            filler char(22)
                        );', i);
    END LOOP;
END$$;


-- Create pgbench_tellers_X tables
DO $$
DECLARE
    i int;
BEGIN
    FOR i IN 0..14 LOOP
        EXECUTE format('CREATE TABLE pgbench_tellers_%s (
                            tid int not null primary key,
                            bid int,
                            tbalance int,
                            filler char(84)
                        );', i);
    END LOOP;
END$$;


-- Create pgbench_accounts_X tables
DO $$
DECLARE
    i int;
BEGIN
    FOR i IN 0..14 LOOP
        EXECUTE format('CREATE TABLE pgbench_accounts_%s (
                            aid bigint not null primary key,
                            bid int,
                            abalance int,
                            filler char(84)
                        );', i);
    END LOOP;
END$$;


-- Create pgbench_branches_X tables
DO $$
DECLARE
    i int;
BEGIN
    FOR i IN 0..14 LOOP
        EXECUTE format('CREATE TABLE pgbench_branches_%s (
                            bid int not null primary key,
                            bbalance int,
                            filler char(88)
                        );', i);
    END LOOP;
END$$;


