/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <stdlib.h>

/* Includes that I added */
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/time.h>
#include "../../interfaces/libpq/libpq-fe.h"
#include "lib/dllist.h"

#define AVD_DEBUG           1
#define BASETHRESHOLD       100
#define SCALINGFACTOR       2
#define SLEEPVALUE          3
#define SLEEPSCALINGFACTOR	2
#define UPDATE_INTERVAL     2
#define TABLE_STATS_ALL     "select a.relfilenode,a.relname,a.relnamespace,a.relpages,a.reltuples,b.schemaname,b.n_tup_ins,b.n_tup_upd,b.n_tup_del from pg_class a, pg_stat_all_tables b where a.relfilenode=b.relid"
#define TABLE_STATS_USER    "select a.relfilenode,a.relname,a.relnamespace,a.relpages,a.reltuples,b.schemaname,b.n_tup_ins,b.n_tup_upd,b.n_tup_del from pg_class a, pg_stat_user_tables b where a.relfilenode=b.relid"
#define FRONTEND

struct cmdargs{
  int tuple_base_threshold,sleep_base_value,debug;
  float tuple_scaling_factor,sleep_scaling_factor;
  char *user, *password, *host, *port;
}; typedef struct cmdargs cmd_args;

/* define cmd_args as global so we can get to them everywhere */
cmd_args  *args;

struct tableinfo{
  char *schema_name,*table_name;
  int insertThreshold,deleteThreshold;
  int relfilenode,reltuples,relpages;
  long insert_stat,update_stat,delete_stat;
  }; typedef struct tableinfo tbl_info;

/* Might need to add a time value for last time the whold database was vacuumed.
    I think we need to guarantee this happens approx every 1Million TX's  */
struct dbinfo{
  int     oid,insertThreshold,deleteThreshold;  /* Use these as database defaults */
  PGconn  *conn;
  char    *dbname,*username,*password;
  Dllist  *table_list;
  }; typedef struct dbinfo db_info;

/* Functions for dealing with command line arguements */
cmd_args *get_cmd_args(int argc,char *argv[]);
void print_cmd_args(void);
void  free_cmd_args(void);

PGresult *send_query(const char *query,db_info *dbi);
char *query_table_stats(db_info *dbi);
char *query_new_table_stats(db_info *dbi);

/* Functions for managing database lists */
Dllist *init_db_list(void);
db_info *init_dbinfo(char *dbname,int oid);
void update_db_list(Dllist *db_list);
void remove_db_from_list(Dlelem *db_to_remove);
void append_new_dbs(Dllist *db_list);
int  check_db(Dlelem *db_elem);
void print_db_info(db_info *dbi,int print_table_list);
void print_db_list(Dllist *db_list,int print_table_lists);

/* Functions for managing table lists */
int init_tables(db_info *dbi);
tbl_info *init_table_info(PGresult *conn, int row);
void update_table_list(db_info *dbi);
void remove_table_from_list(Dlelem *tbl_to_remove);
void append_new_tables(db_info *dbi);
int  check_table(db_info *dbi, tbl_info *tbl);
void print_table_list(Dllist *tbl_node);
void print_table_info(tbl_info *tbl);
void update_tables_thresholds(db_info *dbi);
void update_table_thresholds(db_info *dbi,tbl_info *tbl);

PGconn *db_connect(db_info *dbi);
void db_disconnect(db_info *dbi);


