#!/bin/bash
: <<END_COMMENT


The Relax NG schema 5.x is stricter than the 4.x DTD. In our documentation
- especially when describing commands and functions - there are some
constructions which violates the new syntax.

To address such situations the script on hand modifies indiviual parts of many
files. It is the critical part of the DocBook 4.5 --> 5.2 conversion.

We soleyly use and modify the names of DocBook objects like tags and attributes.
No (english) text is modified! As far as such DocBook objects are not modified
during a translation to other languages like Russian or Spanish, it shut be
possible to use the script also on such translated sgml files.

We use Perl to have the possibility to use negative lookaheads, which
isn't supported by every sed implementation. Example: 's/some(?!xyz)/_some_/g'.
When using multiline pattern (/s modifier) the 'perl -p ...' construct cannot be
used because it enforces line-by-line processing. In such situations we use a script.


END_COMMENT

# ------------------------------------
# -------  parameter handling --------
# ------------------------------------
if [[ $# -ne 1 ]]; then
  echo
  echo Usage: $0 NewSgmlDirectory
  echo Abort.
  echo
  exit 2
fi

cd $1
if [[ $? -ne 0 ]]; then
  echo
  echo sgml directory not found
  echo Abort.
  echo
  exit 2
fi



# -------------
# <literal>
# -------------

# <literal>..<function> is not valid and doesn't have any effect. Remove <literal>
for file in datatype.sgml func.sgml plperl.sgml plpython.sgml pltcl.sgml   \
            ref/create_table.sgml ; do
  # use a more complex perl script to allow multiline-matching
  perl -i -e '
    # slurp-mode to read complete file
    $content = do { local $/; <> };
    # 's' for multiline, 'g' for multiple occurrences, and '?' for non-greedy
    $content =~ s/<literal>(\s*?<function>.*?<\/function>.*?)<\/literal>/\1/sg;
    print $content;
    ' $file
done

# func.sgml only
perl -i -e '
  # slurp-mode to read complete file
  $content = do { local $/; <> };

  # Replace <literal> by <phrase> (single line)
  $content =~ s/<literal>(sum\(.*?)<\/literal>/<phrase>\1<\/phrase>/g;

  # same problem, but multiple lines
  $content =~ s/<literal>((substring|position).*?)<\/literal>/<phrase>\1<\/phrase>/sg;
  $content =~ s/<literal>(<parameter>.*?<\/parameter>.*?)<\/literal>/<phrase>\1<\/phrase>/sg;

  # very special
  $content =~ s/<literal>(\*<parameter>n<\/parameter>\$)<\/literal>/<phrase>\1<\/phrase>/;
  $content =~ s/<literal>(<function>timezone<\/function>.*?)<\/literal>/<phrase>\1<\/phrase>/s;
  $content =~ s/<literal>(<replaceable>timestamp<\/replaceable>.*?)<\/literal>/<phrase>\1<\/phrase>/s;

  print $content;
' func.sgml

#  <literal>..<literal> is not valid   -->   remove outer <literal>
perl -i -p -e 's/^     <literal>(<replaceable>context_item.*)<\/literal>$/     \1/'         func.sgml
perl -i -p -e 's/^     <literal>(<replaceable>name.*)/     \1/'                             func.sgml
perl -i -p -e 's/(.*path_expression<\/replaceable> <\/optional>)<\/literal>/\1/'            func.sgml

#  remove inner <literal>
perl -i -p -e 's/<literal>(from|to)<\/literal>/\1/' ref/psql-ref.sgml


#  <lineannotation>..<literal> is not valid   -->   <lineannotation>..<phrase>
for file in datatype.sgml func.sgml ltree.sgml; do
  perl -i -p -e 's/(lineannotation>.*)<literal>(.*)<\/literal>/\1<phrase>\2<\/phrase>/'     $file
  if [[ $file =~ "func.sgml" ]]; then
    perl -i -p -e 's/(lineannotation>.*)<function>(.*)<\/function>/\1<phrase>\2<\/phrase>/' $file
  fi
done

# plpython.sgml: function name is extend with 'plpy.'. Remove <literal>
perl -i -p -e 's/<term><literal>plpy\.(<function>)(.*)(<\/function>.*)<\/literal>/<term>\1plpy.\2\3/' plpython.sgml

# Remove <literal>
perl -i -p -e 's/<literal>(<function>pg_notify)/\1/;s/<\/literal>(. The function)/\1/' ref/notify.sgml

#  <literal>..<command> is not valid. remove <literal>
perl -i -p -e 's/<literal>(<command>semodule)(<\/command>) -l<\/literal>/\1 -l\2/' sepgsql.sgml

# <literal><option> is not valid. remove <literal>
perl -i -p -e 's/<literal>(<option>.*<\/option>)<\/literal>/\1/' libpq.sgml

#  <option>..<literal> is not valid   -->   <option>..<phrase>
for file in ref/createdb.sgml ref/initdb.sgml; do
  perl -i -p -e 's/<literal>libc<\/literal>/<phrase>libc<\/phrase>/'        $file
  perl -i -p -e 's/<literal>icu<\/literal>/<phrase>icu<\/phrase>/'          $file
  perl -i -p -e 's/<literal>builtin<\/literal>/<phrase>builtin<\/phrase>/'  $file
done
perl -i -p -e 's/<option><literal>(.*)<\/literal><\/option>/<option><phrase>\1<\/phrase><\/option>/' installation.sgml

# <term><literal>..<parameter> is not valid   -->   remove <literal>
perl -i -p -e 's/(<term>)<literal>(.*<parameter>.*<\/parameter>)<\/literal>(<\/term>)/\1\2\3/' spi.sgml
perl -i -p -e 's/(<term>)<literal>(.*)<\/literal>(<\/term>)/\1\2\3/' textsearch.sgml

# <term>\n<literal>..<type> is not valid   -->   change <literal> to <phrase>
perl -i -p -e 's/<literal>((querytree|ts_rewrite|numnode|tsquery_phrase|strip|length|setweight|ts_rank).*)<\/literal>/<phrase>\1<\/phrase>/' textsearch.sgml
perl -i -p -e 's/<literal>(<type>.*<\/type>)<\/literal>/<phrase>\1<\/phrase>/' textsearch.sgml
perl -i -p -e 's/<literal>(\!\!.*)<\/literal>/<phrase>\1<\/phrase>/'           textsearch.sgml

# <literal>..<varname> is not valid   -->   change <literal> to <phrase>
# for old releases:
perl -i -p -e 's/(<literal>)(<varname remap="structname">pg_type<\/varname>)(.oid<\/literal>)/\2\1\3/' btree.sgml
# ... for newer releases:
perl -i -p -e 's/<literal>(<structname>pg_type<\/structname>.oid)<\/literal>/<phrase>\1<\/phrase>/' btree.sgml


# -------------
# <optional>
# -------------
for file in unaccent.sgml tablefunc.sgml pgcrypto.sgml adminpack.sgml datetime.sgml bki.sgml ddl.sgml protocol.sgml   \
            ltree.sgml logicaldecoding.sgml ecpg.sgml lobj.sgml installation.sgml textsearch.sgml func.sgml  \
            ref/alter_function.sgml ref/alter_procedure.sgml ref/clusterdb.sgml ref/create_function.sgml     \
            ref/create_procedure.sgml ref/create_table.sgml ref/pgbench.sgml ref/psql-ref.sgml               \
            ref/reindexdb.sgml ref/select.sgml ref/vacuumdb.sgml ; do
            
  # <optional>..(<type>|<literal>|<...and some more...) is not valid. Use same syntax as
  # in many files of our /ref directory: '[]'
  if [[ -f $file ]]; then
    # some files disapear in new PG versions
    perl -i -p -e 's/<optional>/[/g;s/<\/optional>/]/g' $file
  fi
done


# -------------
# <function>
# -------------

# <function>..(<type>|<parameter>) is not valid  -->  </function> before (<type>|<parameter>)
for file in bgworker.sgml datatype.sgml func.sgml xaggr.sgml; do
  # don't hit 'func_x()' (function without parameters)
  perl -i -e '
    $content = do { local $/; <> };
    $content =~ s/<function>(([\w_]+)\((.*?))(?=\)<\/function>)\)<\/function>/<function>\2<\/function>(\3)/sg;
    print $content;
    ' $file
done


# ---------
# others
# ---------
perl -i -p -e 's/<literal>(a@|foo\*)<\/literal>/<phrase>\1<\/phrase>/' ltree.sgml
if [[ -f "ref/pg_combinebackup.sgml" ]]; then
  perl -i -p -e 's/linkend=\"app-pgchecksums \"/linkend=\"app-pgchecksums\"/' ref/pg_combinebackup.sgml # remove blank
fi


