#!/usr/bin/perl
use strict;

# replace the string '--' by '_minus__minus_' as long as we
# are in CDATA. That's necessary before wrapping CDATA by
# an XML comment. In XML comments the string '--' is not valid.

my $inCDATA = 0;   # false

while (<>) {
  if( /<\!\[CDATA\[/ ) {
    $inCDATA = 1;  # true
  }
  if( /]]>/ ) {
    $inCDATA = 0;   # false
  }
  
  if( $inCDATA ) {
    s/--/_minus__minus_/g;
  }
  
  print $_;
}
