-- polygons_utils.sql --
--
-- SQL code to define polygons functions.
--
-- Copyright (c) 2002, Pierre-Yves -- Lwolf -- Landur <landure@yahoo.fr>
--
-- This file is distributed under the GNU General Public License
-- either version 2, or (at your option) any later version.

-- Return the intersection of two polygon.
--

drop function "poly_intersect" (polygon, polygon);
drop operator # (polygon, polygon);
create function "poly_intersect"(polygon, polygon) returns polygon
  as '$libdir/polygons_utils'
  language 'C';

create operator # (
        leftarg = polygon,
        rightarg = polygon,
        procedure = poly_intersect,
        commutator = #
);

-- test if a polygon intersect (/ overlap) another.
--
drop function "poly_is_intersecting" (polygon, polygon);
drop operator ?# (polygon, polygon);
create function "poly_is_intersecting"(polygon, polygon) returns boolean
  as '$libdir/polygons_utils'
  language 'C';

create operator ?# (
        leftarg = polygon,
        rightarg = polygon,
        procedure = poly_is_intersecting,
        commutator = ?#
);

-- test if a polygon overlap to left another.
--
drop function "poly_overleft" (polygon, polygon);
drop operator &< (polygon, polygon);
create function "poly_overleft"(polygon, polygon) returns boolean
  as '$libdir/polygons_utils'
  language 'C';

create operator &< (
        leftarg = polygon,
        rightarg = polygon,
        procedure = poly_overleft,
        commutator = &>
);
  
-- test if a polygon overlap to right another
--
drop function "poly_overright" (polygon, polygon);
drop operator &> (polygon, polygon);
create function "poly_overright"(polygon, polygon) returns boolean
  as '$libdir/polygons_utils'
  language 'C';

create operator &> (
        leftarg = polygon,
        rightarg = polygon,
        procedure = poly_overright,
        commutator = &<
);
  
-- Test if a polygon overlap another
--
drop function "poly_overlap" (polygon, polygon);
drop operator && (polygon, polygon);
create function "poly_overlap"(polygon, polygon) returns boolean
  as '$libdir/polygons_utils'
  language 'C';

create operator && (
        leftarg = polygon,
        rightarg = polygon,
        procedure = poly_overlap,
        commutator = &&
);

-- Test if a polygon contains another one.
--
drop function "poly_contain" (polygon, polygon);
drop operator @ (polygon, polygon);
create function "poly_contain"(polygon, polygon) returns boolean
  as '$libdir/polygons_utils'
  language 'C';

create operator @ (
        leftarg = polygon,
        rightarg = polygon,
        procedure = poly_contain,
        commutator = @
); 
 
-- Return the gravity center of a polygon
--
drop function "poly_center" (polygon);
drop operator @@ (NONE,polygon);
create function "poly_center"(polygon) returns point
  as '$libdir/polygons_utils'
  language 'C';

create operator @@ (
        rightarg = polygon,
        procedure = poly_center
);

-- Intgration des nouveaux oprateurs aux indexs

DELETE FROM pg_amop WHERE pg_amop.amopclaid IN ( SELECT amopclaid FROM pg_amproc WHERE amproc = regproc('rt_poly_inter')) 
AND amopopr NOT IN (SELECT oid FROM pg_operator );
            
INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 3, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '?#';            

INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_is_intersecting';


INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 3, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '#';            

            
INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_is_intersect';


INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 2, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '&<';            


INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_overleft';


INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 4, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '&>';            


INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_overright';


INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 3, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '&&';            


INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_overlap';


INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 8, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '@';            


INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_contain';

            
INSERT INTO pg_amop (amopclaid, amopstrategy, amopreqcheck, amopopr)
    SELECT opcl.oid, 1, false, o.oid
        FROM pg_opclass opcl, pg_operator o, pg_type t
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            o.oprleft = t.oid and o.oprright = t.oid
            and t.typname = 'polygon'
            and o.oprname = '@@';            


INSERT INTO pg_amproc (amopclaid, amprocnum, amproc)
    SELECT opcl.oid, 1, p.oid
        FROM pg_opclass opcl, pg_proc p
        WHERE
            opcamid = (SELECT oid FROM pg_am WHERE amname = 'rtree') AND
            opcname = 'poly_ops' AND
            p.proname = 'poly_center';

-- end of file
