#!/bin/bash

pub_port=5733
stb1_port=5734
stb2_port=5735
stb3_port=5736
sub1_port=5737

echo '=========='
echo '=Clean up='
echo '=========='

./pg_ctl stop -D ../../primary
rm -rf  ../../primary

./pg_ctl stop -D ../../standbydb1
rm -rf  ../../standbydb1



echo '=================================================================================================='
echo '=Set up primary server='
echo '=================================================================================================='

./initdb -D ../../primary

cat << EOF >> ../../primary/postgresql.conf
port = $pub_port
wal_level = logical
standby_slot_names = 'standby_1' 
max_wal_senders=550
max_replication_slots=550 
log_replication_commands = 'on' 
checkpoint_timeout = 1d 
shared_buffers = 40GB 
max_worker_processes = 32 
max_parallel_maintenance_workers = 24 
max_parallel_workers = 32 
synchronous_commit = off 
max_wal_size = 24GB 
min_wal_size = 15GB 
autovacuum = off 
EOF


cat << EOF >> ../../primary/pg_hba.conf
host all,replication all 0.0.0.0/0 trust
EOF

./pg_ctl -D ../../primary -w -l ../../primary.log start

###################################################################

./psql -p $pub_port -d postgres -c "SELECT pg_create_physical_replication_slot('standby_1');"
./psql -p $pub_port -d postgres -c "CREATE ROLE replication WITH REPLICATION PASSWORD 'password' LOGIN;"
./psql -p $pub_port -d postgres -f "/home/nisha/project/pg1/sync_lsn_perf/createdb20.sql"

## pgbench table creation
./pgbench -p $pub_port postgres -qis 2

./pg_ctl -D ../../primary -w -l ../../primary.log restart
echo '===================================================================================================='
echo '=Set up standby servers'
echo '===================================================================================================='

./pg_basebackup -h 127.0.0.1 -D ../../standbydb1  -R -P -U replication -X s  -p $pub_port

cat << EOF >> ../../standbydb1/postgresql.conf
port = $stb1_port
primary_slot_name = 'standby_1'
hot_standby_feedback = on
standby_slot_names = ''
EOF

sed -i 's/hosts=disable/hosts=disable dbname=postgres/g' ../../standbydb1/postgresql.auto.conf

./pg_ctl -D ../../standbydb1 -w -l ../../standbydb1.log start

##########################################################################################################
##########################################################################################################


