#define USE_POSIX_TIME
#define HAS_TEST_AND_SET
#undef HAVE_INT_TIMEZONE
#define DARWIN_OS

typedef unsigned int slock_t;

/* sysv sem.h (need for osxpb) */
#ifndef HAVE_SYS_SEM_H

#ifndef _SYS_SEM_H
#define _SYS_SEM_H

#undef HAVE_UNION_SEMUN
#define HAVE_UNION_SEMUN 1

#include <sys/types.h>
#include <sys/ipc.h>

#ifdef __cplusplus
extern          "C"
{
#endif
  
  /*
   *      Semctl Command Definitions.
   */
  
#define GETNCNT 3                               /* get semncnt */
#define GETPID  4                               /* get sempid */
#define GETVAL  5                               /* get semval */
#define GETALL  6                               /* get all semval's */
#define GETZCNT 7                               /* get semzcnt */
#define SETVAL  8                               /* set semval */
#define SETALL  9                               /* set all semval's */
  
  struct sem
  {
    u_short semval;         /* semaphore text map address   */
    pid_t   sempid;         /* pid of last operation        */
    u_short semncnt;        /* # awaiting semval > cval */
    u_short semzcnt;        /* # awaiting semval = 0        */
  };
  
  struct sembuf
  {
    u_short sem_num;        /* semaphore #                  */
    short   sem_op;         /* semaphore operation          */
    short   sem_flg;        /* operation flags              */
  };

  union semun
  {
    int                     val;
    struct semid_ds *buf;
    unsigned short *array;
  };  
  
extern int      semctl(int semid, int semnum, int cmd, union semun arg);
  extern int      semget(key_t key, int nsems, int semflg);
  extern int      semop(int semid, struct sembuf * sops, size_t nsops);
  
#ifdef __cplusplus
}
#endif
#endif
#endif  /* end sysv sem.h */  







