/*-------------------------------------------------------------------------
 *
 * port_protos.h
 *	  port-specific prototypes for Darwin
 *
 *-------------------------------------------------------------------------
 */

#ifndef PORT_PROTOS_H
#define PORT_PROTOS_H

#include <sys/types.h>
#include "postgres.h"
#include "fmgr.h"
#include "utils/dynamic_loader.h"

#define		   pg_dlopen       pg_os_dso_load
#define		   pg_dlsym	   pg_os_dso_sym
#define		   pg_dlclose	   pg_os_dso_unload
#define		   pg_dlerror	   pg_os_dso_error

void *      pg_os_dso_load(const char *);
void        pg_os_dso_unload(void *);
void *      pg_os_dso_sym(void *, const char *);
const char *pg_os_dso_error(void);

#endif	 /* PORT_PROTOS_H */
