SHOW default_toast_compression;

CREATE TABLE IF NOT EXISTS "DataRecords" (
    filename character varying(255) COLLATE pg_catalog."default" NOT NULL,
    "timestamp" timestamp without time zone NOT NULL,
    data jsonb NOT NULL DEFAULT '{}'::jsonb,
    created_at timestamp with time zone NOT NULL,
    updated_at timestamp with time zone NOT NULL,
    CONSTRAINT "DataRecords_pkey" PRIMARY KEY (filename, "timestamp")
);

DO LANGUAGE plpgsql $$
  DECLARE
    start_timestamp timestamp without time zone := '2023-12-01 00:00:00';
    end_timestamp timestamp without time zone := '2023-12-01 01:00:00';
  BEGIN
    WHILE start_timestamp < end_timestamp LOOP
      EXECUTE 'INSERT INTO "DataRecords" (filename,timestamp,data,created_at,updated_at) VALUES (''test_file.dat'',' || quote_literal(to_char(start_timestamp,'YYYY-MM-DD HH24:MI:SS')) || ',''{
  "key1": 354,
  "key2": 741,
  "key3": 51,
  "key4": 595,
  "key5": 1,
  "key6": 589,
  "key7": 792,
  "key8": 530,
  "key9": 370,
  "key10": 521,
  "key11": 46,
  "key12": 360,
  "key13": 703,
  "key14": 582,
  "key15": 266,
  "key16": 384,
  "key17": 456,
  "key18": 704,
  "key19": 859,
  "key20": 675,
  "key21": 971,
  "key22": 607,
  "key23": 206,
  "key24": 907,
  "key25": 636,
  "key26": 766,
  "key27": 827,
  "key28": 516,
  "key29": 611,
  "key30": 676,
  "key31": 153,
  "key32": 88,
  "key33": 292,
  "key34": 773,
  "key35": 932,
  "key36": 255,
  "key37": 422,
  "key38": 396,
  "key39": 581,
  "key40": 322,
  "key41": 951,
  "key42": 687,
  "key43": 145,
  "key44": 500,
  "key45": 686,
  "key46": 513,
  "key47": 216,
  "key48": 175,
  "key49": 613,
  "key50": 750,
  "key51": 262,
  "key52": 836,
  "key53": 818,
  "key54": 421,
  "key55": 371,
  "key56": 13,
  "key57": 849,
  "key58": 470,
  "key59": 884,
  "key60": 608,
  "key61": 133,
  "key62": 314,
  "key63": 173,
  "key64": 220,
  "key65": 573,
  "key66": 624,
  "key67": 919,
  "key68": 144,
  "key69": 225,
  "key70": 83,
  "key71": 232,
  "key72": 294,
  "key73": 672,
  "key74": 316,
  "key75": 257,
  "key76": 746,
  "key77": 137,
  "key78": 738,
  "key79": 737,
  "key80": 122,
  "key81": 101,
  "key82": 501,
  "key83": 416,
  "key84": 763,
  "key85": 814,
  "key86": 774,
  "key87": 382,
  "key88": 432,
  "key89": 441,
  "key90": 694,
  "key91": 298,
  "key92": 187,
  "key93": 55,
  "key94": 359,
  "key95": 422,
  "key96": 326,
  "key97": 693,
  "key98": 830,
  "key99": 81,
  "key100": 985
}
'',NOW(),NOW()) ON CONFLICT (filename,timestamp) DO UPDATE SET data = excluded.data, updated_at = NOW()';
      start_timestamp := start_timestamp + '1 minute'::INTERVAL;
    END LOOP;
  END;
$$;

SELECT max(pg_column_size(data)) FROM "DataRecords";
