#!/usr/bin/env python3
import numpy as np
from scipy import stats
import re
import math

versions = ['master', 'v15']
runs = range(1, 11)

tps_regex = r'^tps = (\d+\.\d+) '

def get_tps(fname):
	with open(fname, 'rt') as fh:
		for line in fh:
			pass
		last = line
	match = re.search(tps_regex, last)
	tps = match.groups()[0]
	tps = float(tps)
	return tps

data = {}
for version in versions:
	data[version] = []
	for run in runs:
		fname = 'log-%s-%s.log' % (version, str(run))
		tps = get_tps(fname)
		data[version].append(tps)

for version in versions:
	l = data[version]
	average = np.average(l)
	stddev = np.std(l)
	error = stats.t.interval(0.95, len(l) - 1, loc=0, scale= stddev / math.sqrt(len(l)))[1]
	print('%s = %s +- %s' % (version, str(average), str(error)))
