--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: area; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE area (
    code character varying(5) NOT NULL,
    name character varying(255),
    status character varying(255)
);


ALTER TABLE public.area OWNER TO postgres;

--
-- Name: category; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE category (
    code character varying(20) NOT NULL,
    description character varying(255),
    status character varying(255),
    family_code character varying(20),
    idx integer
);


ALTER TABLE public.category OWNER TO postgres;

--
-- Name: department; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE department (
    code character varying(20) NOT NULL,
    description character varying(255),
    status character varying(255),
    sub_category_code character varying(20),
    idx integer
);


ALTER TABLE public.department OWNER TO postgres;

--
-- Name: family; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE family (
    code character varying(20) NOT NULL,
    description character varying(255),
    status character varying(255)
);


ALTER TABLE public.family OWNER TO postgres;

--
-- Name: sale_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.sale_id_seq OWNER TO postgres;

--
-- Name: sale_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sale_id_seq', 1, false);


--
-- Name: state; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE state (
    code character varying(5) NOT NULL,
    name character varying(255),
    status character varying(255)
);


ALTER TABLE public.state OWNER TO postgres;

--
-- Name: stkchannel_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE stkchannel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.stkchannel_id_seq OWNER TO postgres;

--
-- Name: stkchannel_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('stkchannel_id_seq', 1, false);


--
-- Name: stkretail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE stkretail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.stkretail_id_seq OWNER TO postgres;

--
-- Name: stkretail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('stkretail_id_seq', 1, false);


--
-- Name: sub_category; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sub_category (
    code character varying(20) NOT NULL,
    description character varying(255),
    status character varying(255),
    category_code character varying(20),
    idx integer
);


ALTER TABLE public.sub_category OWNER TO postgres;

--
-- Data for Name: area; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY area (code, name, status) FROM stdin;
﻿ENC	East North Central	ACTIVE
ESC	East South Central	ACTIVE
M	Mountain	ACTIVE
MA	Middle Atlantic	ACTIVE
NE	New England	ACTIVE
P	Pacific	ACTIVE
SA	South Atlantic	ACTIVE
WNC	West North Central	ACTIVE
WSC	West South Central	ACTIVE
ENC	ENC	ACTIVE
\.


--
-- Data for Name: category; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY category (code, description, status, family_code, idx) FROM stdin;
﻿10062002	Sample description	ACTIVE	\N	\N
10062003	Sample description	ACTIVE	\N	\N
10062075	Sample description	ACTIVE	\N	\N
10062006	Sample description	ACTIVE	\N	\N
10062007	Sample description	ACTIVE	\N	\N
10062009	Sample description	ACTIVE	\N	\N
10062113	Sample description	ACTIVE	\N	\N
10062017	Sample description	ACTIVE	\N	\N
10062018	Sample description	ACTIVE	\N	\N
10062077	Sample description	ACTIVE	\N	\N
10062078	Sample description	ACTIVE	\N	\N
10062024	Sample description	ACTIVE	\N	\N
10062027	Sample description	ACTIVE	\N	\N
10062079	Sample description	ACTIVE	\N	\N
10062042	Sample description	ACTIVE	\N	\N
10062043	Sample description	ACTIVE	\N	\N
10062044	Sample description	ACTIVE	\N	\N
10062074	Sample description	ACTIVE	\N	\N
10062080	Sample description	ACTIVE	\N	\N
10062076	Sample description	ACTIVE	\N	\N
10062081	Sample description	ACTIVE	\N	\N
10062082	Sample description	ACTIVE	\N	\N
10062058	Sample description	ACTIVE	\N	\N
10002083	Sample description	ACTIVE	1000	\N
10002112	Sample description	ACTIVE	1000	\N
10002086	Sample description	ACTIVE	1000	\N
10002085	Sample description	ACTIVE	1000	\N
10002005	Sample description	ACTIVE	1000	\N
10002087	Sample description	ACTIVE	1000	\N
10002088	Sample description	ACTIVE	1000	\N
10002111	Sample description	ACTIVE	1000	\N
10002089	Sample description	ACTIVE	1000	\N
10002091	Sample description	ACTIVE	1000	\N
10002032	Sample description	ACTIVE	1000	\N
10002040	Sample description	ACTIVE	1000	\N
10002090	Sample description	ACTIVE	1000	\N
10002045	Sample description	ACTIVE	1000	\N
10002073	Sample description	ACTIVE	1000	\N
10032028	Sample description	ACTIVE	1003	\N
10032048	Sample description	ACTIVE	1003	\N
10032019	Sample description	ACTIVE	1003	\N
10032049	Sample description	ACTIVE	1003	\N
10032055	Sample description	ACTIVE	1003	\N
10032041	Sample description	ACTIVE	1003	\N
10032023	Sample description	ACTIVE	1003	\N
10032052	Sample description	ACTIVE	1003	\N
10032033	Sample description	ACTIVE	1003	\N
10042026	Sample description	ACTIVE	1004	\N
10042025	Sample description	ACTIVE	1004	\N
10042039	Sample description	ACTIVE	1004	\N
10072047	Sample description	ACTIVE	1007	\N
10072046	Sample description	ACTIVE	1007	\N
10052013	Sample description	ACTIVE	1005	\N
10052014	Sample description	ACTIVE	1005	\N
10052034	Sample description	ACTIVE	1005	\N
10052066	Sample description	ACTIVE	1005	\N
10022059	Sample description	ACTIVE	1002	\N
10112101	Sample description	ACTIVE	1011	\N
10112092	Sample description	ACTIVE	1011	\N
10112094	Sample description	ACTIVE	1011	\N
10112093	Sample description	ACTIVE	1011	\N
10112095	Sample description	ACTIVE	1011	\N
10112108	Sample description	ACTIVE	1011	\N
10112104	Sample description	ACTIVE	1011	\N
10112097	Sample description	ACTIVE	1011	\N
10112107	Sample description	ACTIVE	1011	\N
10112099	Sample description	ACTIVE	1011	\N
10112100	Sample description	ACTIVE	1011	\N
10082062	Sample description	ACTIVE	1008	\N
10082063	Sample description	ACTIVE	1008	\N
10082064	Sample description	ACTIVE	1008	\N
10082061	Sample description	ACTIVE	1008	\N
10082065	Sample description	ACTIVE	1008	\N
10082060	Sample description	ACTIVE	1008	\N
10102000	Sample description	ACTIVE	1010	\N
10102071	Sample description	ACTIVE	1010	\N
10012035	Sample description	ACTIVE	1001	\N
10012036	Sample description	ACTIVE	1001	\N
10092050	Sample description	ACTIVE	1009	\N
\.


--
-- Data for Name: department; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY department (code, description, status, sub_category_code, idx) FROM stdin;
﻿1006200240056241	Sample description	ACTIVE	\N	\N
1006200240056730	Sample description	ACTIVE	\N	\N
1006200240056966	Sample description	ACTIVE	\N	\N
1006200240476096	Sample description	ACTIVE	100620024047	\N
1006200240476760	Sample description	ACTIVE	100620024047	\N
1006200240477376	Sample description	ACTIVE	100620024047	\N
1006200341736220	Sample description	ACTIVE	100620034173	\N
1006200341736219	Sample description	ACTIVE	100620034173	\N
1006200341786139	Sample description	ACTIVE	100620034178	\N
1006200341786138	Sample description	ACTIVE	100620034178	\N
1006200341787211	Sample description	ACTIVE	100620034178	\N
1006200341766136	Sample description	ACTIVE	100620034176	\N
1006200341766134	Sample description	ACTIVE	100620034176	\N
1006200341816392	Sample description	ACTIVE	100620034181	\N
1006200341826395	Sample description	ACTIVE	100620034182	\N
1006200341846400	Sample description	ACTIVE	100620034184	\N
1006200341806142	Sample description	ACTIVE	100620034180	\N
1006200341806144	Sample description	ACTIVE	100620034180	\N
1006200341806214	Sample description	ACTIVE	100620034180	\N
1006200341806217	Sample description	ACTIVE	100620034180	\N
1006200341806218	Sample description	ACTIVE	100620034180	\N
1006200341746221	Sample description	ACTIVE	100620034174	\N
1006200341757454	Sample description	ACTIVE	100620034175	\N
1006200341756159	Sample description	ACTIVE	100620034175	\N
1006200341756162	Sample description	ACTIVE	100620034175	\N
1006200341756163	Sample description	ACTIVE	100620034175	\N
1006200341756166	Sample description	ACTIVE	100620034175	\N
1006200341756167	Sample description	ACTIVE	100620034175	\N
1006200341756148	Sample description	ACTIVE	100620034175	\N
1006200341756147	Sample description	ACTIVE	100620034175	\N
1006200341756180	Sample description	ACTIVE	100620034175	\N
1006200341756177	Sample description	ACTIVE	100620034175	\N
1006200341756184	Sample description	ACTIVE	100620034175	\N
1006200341756185	Sample description	ACTIVE	100620034175	\N
1006200341756187	Sample description	ACTIVE	100620034175	\N
1006200341756146	Sample description	ACTIVE	100620034175	\N
1006200341756165	Sample description	ACTIVE	100620034175	\N
1006200341756169	Sample description	ACTIVE	100620034175	\N
1006200341756174	Sample description	ACTIVE	100620034175	\N
1006200341756175	Sample description	ACTIVE	100620034175	\N
1006200341756176	Sample description	ACTIVE	100620034175	\N
1006200341756178	Sample description	ACTIVE	100620034175	\N
1006200341797487	Sample description	ACTIVE	100620034179	\N
1006200341797498	Sample description	ACTIVE	100620034179	\N
1006200341796191	Sample description	ACTIVE	100620034179	\N
1006200341796192	Sample description	ACTIVE	100620034179	\N
1006200341796193	Sample description	ACTIVE	100620034179	\N
1006200341796194	Sample description	ACTIVE	100620034179	\N
1006200341796206	Sample description	ACTIVE	100620034179	\N
1006200341796208	Sample description	ACTIVE	100620034179	\N
1006200341796209	Sample description	ACTIVE	100620034179	\N
1006200341796211	Sample description	ACTIVE	100620034179	\N
1006200341796212	Sample description	ACTIVE	100620034179	\N
1006200341796213	Sample description	ACTIVE	100620034179	\N
1006200341796195	Sample description	ACTIVE	100620034179	\N
1006200341796197	Sample description	ACTIVE	100620034179	\N
1006200341796199	Sample description	ACTIVE	100620034179	\N
1006200341796200	Sample description	ACTIVE	100620034179	\N
1006200341796201	Sample description	ACTIVE	100620034179	\N
1006200341796205	Sample description	ACTIVE	100620034179	\N
1006200341836399	Sample description	ACTIVE	100620034183	\N
1006200341777494	Sample description	ACTIVE	100620034177	\N
1006200341777493	Sample description	ACTIVE	100620034177	\N
1006200341776690	Sample description	ACTIVE	100620034177	\N
1006200341776393	Sample description	ACTIVE	100620034177	\N
1006200341776394	Sample description	ACTIVE	100620034177	\N
1006200341776396	Sample description	ACTIVE	100620034177	\N
1006200341776397	Sample description	ACTIVE	100620034177	\N
1006200341777501	Sample description	ACTIVE	100620034177	\N
1006200341776402	Sample description	ACTIVE	100620034177	\N
1006200341776401	Sample description	ACTIVE	100620034177	\N
1006200341856432	Sample description	ACTIVE	100620034185	\N
1006200341856433	Sample description	ACTIVE	100620034185	\N
1006200341856986	Sample description	ACTIVE	100620034185	\N
1006207541896158	Sample description	ACTIVE	100620754189	\N
1006207541896552	Sample description	ACTIVE	100620754189	\N
1006207541896149	Sample description	ACTIVE	100620754189	\N
1006207541897022	Sample description	ACTIVE	100620754189	\N
1006207541876133	Sample description	ACTIVE	100620754187	\N
1006207541916549	Sample description	ACTIVE	100620754191	\N
1006207541886157	Sample description	ACTIVE	100620754188	\N
1006207541926551	Sample description	ACTIVE	100620754192	\N
1006207541906226	Sample description	ACTIVE	100620754190	\N
1006207541906228	Sample description	ACTIVE	100620754190	\N
1006207541906229	Sample description	ACTIVE	100620754190	\N
1006207541906231	Sample description	ACTIVE	100620754190	\N
1006207541906232	Sample description	ACTIVE	100620754190	\N
1006207541907438	Sample description	ACTIVE	100620754190	\N
1006207541906155	Sample description	ACTIVE	100620754190	\N
1006207541906703	Sample description	ACTIVE	100620754190	\N
1006207541907434	Sample description	ACTIVE	100620754190	\N
1006207541907520	Sample description	ACTIVE	100620754190	\N
1006207541906234	Sample description	ACTIVE	100620754190	\N
1006207541906550	Sample description	ACTIVE	100620754190	\N
1006207541906553	Sample description	ACTIVE	100620754190	\N
1006207541906150	Sample description	ACTIVE	100620754190	\N
1006207541906153	Sample description	ACTIVE	100620754190	\N
1006207541906154	Sample description	ACTIVE	100620754190	\N
1006200641936255	Sample description	ACTIVE	100620064193	\N
1006200641936244	Sample description	ACTIVE	100620064193	\N
1006200641976505	Sample description	ACTIVE	100620064197	\N
1006200642027297	Sample description	ACTIVE	100620064202	\N
1006200641966243	Sample description	ACTIVE	100620064196	\N
1006200641966256	Sample description	ACTIVE	100620064196	\N
1006200641966246	Sample description	ACTIVE	100620064196	\N
1006200642016506	Sample description	ACTIVE	100620064201	\N
1006200642016507	Sample description	ACTIVE	100620064201	\N
1006200642016514	Sample description	ACTIVE	100620064201	\N
1006200642007425	Sample description	ACTIVE	100620064200	\N
1006200642007299	Sample description	ACTIVE	100620064200	\N
1006200742037481	Sample description	ACTIVE	100620074203	\N
1006200742036261	Sample description	ACTIVE	100620074203	\N
1006200742046265	Sample description	ACTIVE	100620074204	\N
1006200742056268	Sample description	ACTIVE	100620074205	\N
1006200742076272	Sample description	ACTIVE	100620074207	\N
1006200742086279	Sample description	ACTIVE	100620074208	\N
1006200742106296	Sample description	ACTIVE	100620074210	\N
1006200742116738	Sample description	ACTIVE	100620074211	\N
1006200742126271	Sample description	ACTIVE	100620074212	\N
1006200742066267	Sample description	ACTIVE	100620074206	\N
1006200942156369	Sample description	ACTIVE	100620094215	\N
1006200942156367	Sample description	ACTIVE	100620094215	\N
1006200942156358	Sample description	ACTIVE	100620094215	\N
1006200942157209	Sample description	ACTIVE	100620094215	\N
1006200942157207	Sample description	ACTIVE	100620094215	\N
1006200942157206	Sample description	ACTIVE	100620094215	\N
1006200942156368	Sample description	ACTIVE	100620094215	\N
1006200942156364	Sample description	ACTIVE	100620094215	\N
1006200942156355	Sample description	ACTIVE	100620094215	\N
1006200942156354	Sample description	ACTIVE	100620094215	\N
1006200942136098	Sample description	ACTIVE	100620094213	\N
1006200942186281	Sample description	ACTIVE	100620094218	\N
1006200942186291	Sample description	ACTIVE	100620094218	\N
1006200942186282	Sample description	ACTIVE	100620094218	\N
1006200942186286	Sample description	ACTIVE	100620094218	\N
1006200940246285	Sample description	ACTIVE	100620094024	\N
1006200940246283	Sample description	ACTIVE	100620094024	\N
1006200940246287	Sample description	ACTIVE	100620094024	\N
1006200940246292	Sample description	ACTIVE	100620094024	\N
1006200940246293	Sample description	ACTIVE	100620094024	\N
1006200940936764	Sample description	ACTIVE	100620094093	\N
1006200940936765	Sample description	ACTIVE	100620094093	\N
1006200940936766	Sample description	ACTIVE	100620094093	\N
1006200940936767	Sample description	ACTIVE	100620094093	\N
1006200940936768	Sample description	ACTIVE	100620094093	\N
1006200940936769	Sample description	ACTIVE	100620094093	\N
1006200940936770	Sample description	ACTIVE	100620094093	\N
1006200940936773	Sample description	ACTIVE	100620094093	\N
1006200940936774	Sample description	ACTIVE	100620094093	\N
1006200940936775	Sample description	ACTIVE	100620094093	\N
1006200940936776	Sample description	ACTIVE	100620094093	\N
1006200940936777	Sample description	ACTIVE	100620094093	\N
1006200942177490	Sample description	ACTIVE	100620094217	\N
1006200942176361	Sample description	ACTIVE	100620094217	\N
1006200942176360	Sample description	ACTIVE	100620094217	\N
1006200942176362	Sample description	ACTIVE	100620094217	\N
1006200942176366	Sample description	ACTIVE	100620094217	\N
1006200942176352	Sample description	ACTIVE	100620094217	\N
1006200942146099	Sample description	ACTIVE	100620094214	\N
1006200942146100	Sample description	ACTIVE	100620094214	\N
1006200942146101	Sample description	ACTIVE	100620094214	\N
1006200942146105	Sample description	ACTIVE	100620094214	\N
1006200942146106	Sample description	ACTIVE	100620094214	\N
1006200942146112	Sample description	ACTIVE	100620094214	\N
1006200942146353	Sample description	ACTIVE	100620094214	\N
1006200942146118	Sample description	ACTIVE	100620094214	\N
1006200942146122	Sample description	ACTIVE	100620094214	\N
1006200942146123	Sample description	ACTIVE	100620094214	\N
1006200942147458	Sample description	ACTIVE	100620094214	\N
1006200942146124	Sample description	ACTIVE	100620094214	\N
1006200942147457	Sample description	ACTIVE	100620094214	\N
1006211342206518	Sample description	ACTIVE	100621134220	\N
1006211342216891	Sample description	ACTIVE	100621134221	\N
1006211342196519	Sample description	ACTIVE	100621134219	\N
1006211342196521	Sample description	ACTIVE	100621134219	\N
1006211342196522	Sample description	ACTIVE	100621134219	\N
1006211342196523	Sample description	ACTIVE	100621134219	\N
1006211342196524	Sample description	ACTIVE	100621134219	\N
1006211342196525	Sample description	ACTIVE	100621134219	\N
1006211342196546	Sample description	ACTIVE	100621134219	\N
1006211342196547	Sample description	ACTIVE	100621134219	\N
1006211342196540	Sample description	ACTIVE	100621134219	\N
1006211342196541	Sample description	ACTIVE	100621134219	\N
1006211342196542	Sample description	ACTIVE	100621134219	\N
1006211342196543	Sample description	ACTIVE	100621134219	\N
1006211342196544	Sample description	ACTIVE	100621134219	\N
1006211342196545	Sample description	ACTIVE	100621134219	\N
1006211342196534	Sample description	ACTIVE	100621134219	\N
1006211342196535	Sample description	ACTIVE	100621134219	\N
1006211342196536	Sample description	ACTIVE	100621134219	\N
1006211342196537	Sample description	ACTIVE	100621134219	\N
1006211342196538	Sample description	ACTIVE	100621134219	\N
1006211342196539	Sample description	ACTIVE	100621134219	\N
1006211342196526	Sample description	ACTIVE	100621134219	\N
1006211342196531	Sample description	ACTIVE	100621134219	\N
1006211342196528	Sample description	ACTIVE	100621134219	\N
1006211342196529	Sample description	ACTIVE	100621134219	\N
1006211342196530	Sample description	ACTIVE	100621134219	\N
1006211342196532	Sample description	ACTIVE	100621134219	\N
1006211342226892	Sample description	ACTIVE	100621134222	\N
1006211342226894	Sample description	ACTIVE	100621134222	\N
1006211342226895	Sample description	ACTIVE	100621134222	\N
1006211342226896	Sample description	ACTIVE	100621134222	\N
1006211342226897	Sample description	ACTIVE	100621134222	\N
1006211342226898	Sample description	ACTIVE	100621134222	\N
1006211342226924	Sample description	ACTIVE	100621134222	\N
1006211342226917	Sample description	ACTIVE	100621134222	\N
1006211342226919	Sample description	ACTIVE	100621134222	\N
1006211342226920	Sample description	ACTIVE	100621134222	\N
1006211342226921	Sample description	ACTIVE	100621134222	\N
1006211342226922	Sample description	ACTIVE	100621134222	\N
1006211342226923	Sample description	ACTIVE	100621134222	\N
1006211342226911	Sample description	ACTIVE	100621134222	\N
1006211342226912	Sample description	ACTIVE	100621134222	\N
1006211342226913	Sample description	ACTIVE	100621134222	\N
1006211342226914	Sample description	ACTIVE	100621134222	\N
1006211342226915	Sample description	ACTIVE	100621134222	\N
1006211342226916	Sample description	ACTIVE	100621134222	\N
1006211342226906	Sample description	ACTIVE	100621134222	\N
1006211342226907	Sample description	ACTIVE	100621134222	\N
1006211342227488	Sample description	ACTIVE	100621134222	\N
1006211342226908	Sample description	ACTIVE	100621134222	\N
1006211342226909	Sample description	ACTIVE	100621134222	\N
1006211342226910	Sample description	ACTIVE	100621134222	\N
1006211342226899	Sample description	ACTIVE	100621134222	\N
1006211342226901	Sample description	ACTIVE	100621134222	\N
1006211342226902	Sample description	ACTIVE	100621134222	\N
1006211342226903	Sample description	ACTIVE	100621134222	\N
1006211342226904	Sample description	ACTIVE	100621134222	\N
1006211342226905	Sample description	ACTIVE	100621134222	\N
1006201742277183	Sample description	ACTIVE	100620174227	\N
1006201742266466	Sample description	ACTIVE	100620174226	\N
1006201742316928	Sample description	ACTIVE	100620174231	\N
1006201742307475	Sample description	ACTIVE	100620174230	\N
1006201742307489	Sample description	ACTIVE	100620174230	\N
1006201742307456	Sample description	ACTIVE	100620174230	\N
1006201742307472	Sample description	ACTIVE	100620174230	\N
1006201742307184	Sample description	ACTIVE	100620174230	\N
1006201742307185	Sample description	ACTIVE	100620174230	\N
1006201742307193	Sample description	ACTIVE	100620174230	\N
1006201742307194	Sample description	ACTIVE	100620174230	\N
1006201742307191	Sample description	ACTIVE	100620174230	\N
1006201742307187	Sample description	ACTIVE	100620174230	\N
1006201742307449	Sample description	ACTIVE	100620174230	\N
1006201742307188	Sample description	ACTIVE	100620174230	\N
1006201742307189	Sample description	ACTIVE	100620174230	\N
1006201742307190	Sample description	ACTIVE	100620174230	\N
1006201742307192	Sample description	ACTIVE	100620174230	\N
1006201742286473	Sample description	ACTIVE	100620174228	\N
1006201742287396	Sample description	ACTIVE	100620174228	\N
1006201742327474	Sample description	ACTIVE	100620174232	\N
1006201742327471	Sample description	ACTIVE	100620174232	\N
1006201742326929	Sample description	ACTIVE	100620174232	\N
1006201742326930	Sample description	ACTIVE	100620174232	\N
1006201742326931	Sample description	ACTIVE	100620174232	\N
1006201742327451	Sample description	ACTIVE	100620174232	\N
1006201742326932	Sample description	ACTIVE	100620174232	\N
1006201840556116	Sample description	ACTIVE	100620184055	\N
1006201840556121	Sample description	ACTIVE	100620184055	\N
1006201840556276	Sample description	ACTIVE	100620184055	\N
1006201840556297	Sample description	ACTIVE	100620184055	\N
1006201840556407	Sample description	ACTIVE	100620184055	\N
1006201840556424	Sample description	ACTIVE	100620184055	\N
1006201840557057	Sample description	ACTIVE	100620184055	\N
1006201840557152	Sample description	ACTIVE	100620184055	\N
1006201840557292	Sample description	ACTIVE	100620184055	\N
1006201840556613	Sample description	ACTIVE	100620184055	\N
1006201840557058	Sample description	ACTIVE	100620184055	\N
1006201840557059	Sample description	ACTIVE	100620184055	\N
1006201840557060	Sample description	ACTIVE	100620184055	\N
1006201840557061	Sample description	ACTIVE	100620184055	\N
1006201840557051	Sample description	ACTIVE	100620184055	\N
1006201840556431	Sample description	ACTIVE	100620184055	\N
1006201840556423	Sample description	ACTIVE	100620184055	\N
1006201840556469	Sample description	ACTIVE	100620184055	\N
1006201840556484	Sample description	ACTIVE	100620184055	\N
1006201840556499	Sample description	ACTIVE	100620184055	\N
1006201840556503	Sample description	ACTIVE	100620184055	\N
1006201840536222	Sample description	ACTIVE	100620184053	\N
1006201840536223	Sample description	ACTIVE	100620184053	\N
1006201840536240	Sample description	ACTIVE	100620184053	\N
1006201840536527	Sample description	ACTIVE	100620184053	\N
1006201840537087	Sample description	ACTIVE	100620184053	\N
1006201840537380	Sample description	ACTIVE	100620184053	\N
1006207740676593	Sample description	ACTIVE	100620774067	\N
1006207740676584	Sample description	ACTIVE	100620774067	\N
1006207740676580	Sample description	ACTIVE	100620774067	\N
1006207740677427	Sample description	ACTIVE	100620774067	\N
1006207740676594	Sample description	ACTIVE	100620774067	\N
1006207740676579	Sample description	ACTIVE	100620774067	\N
1006207740676592	Sample description	ACTIVE	100620774067	\N
1006207842376569	Sample description	ACTIVE	100620784237	\N
1006207842406317	Sample description	ACTIVE	100620784240	\N
1006207842406570	Sample description	ACTIVE	100620784240	\N
1006207842406571	Sample description	ACTIVE	100620784240	\N
1006207842406572	Sample description	ACTIVE	100620784240	\N
1006207842406583	Sample description	ACTIVE	100620784240	\N
1006207842406581	Sample description	ACTIVE	100620784240	\N
1006207842406743	Sample description	ACTIVE	100620784240	\N
1006207842386596	Sample description	ACTIVE	100620784238	\N
1006207842396578	Sample description	ACTIVE	100620784239	\N
1006207842396590	Sample description	ACTIVE	100620784239	\N
1006202442426620	Sample description	ACTIVE	100620244242	\N
1006202442416621	Sample description	ACTIVE	100620244241	\N
1006202442416622	Sample description	ACTIVE	100620244241	\N
1006202442416623	Sample description	ACTIVE	100620244241	\N
1006202442416624	Sample description	ACTIVE	100620244241	\N
1006202442416625	Sample description	ACTIVE	100620244241	\N
1006202442416626	Sample description	ACTIVE	100620244241	\N
1006202442416643	Sample description	ACTIVE	100620244241	\N
1006202442417468	Sample description	ACTIVE	100620244241	\N
1006202442416637	Sample description	ACTIVE	100620244241	\N
1006202442416638	Sample description	ACTIVE	100620244241	\N
1006202442416639	Sample description	ACTIVE	100620244241	\N
1006202442416641	Sample description	ACTIVE	100620244241	\N
1006202442417467	Sample description	ACTIVE	100620244241	\N
1006202442416627	Sample description	ACTIVE	100620244241	\N
1006202442416628	Sample description	ACTIVE	100620244241	\N
1006202442416632	Sample description	ACTIVE	100620244241	\N
1006202442416633	Sample description	ACTIVE	100620244241	\N
1006202442416634	Sample description	ACTIVE	100620244241	\N
1006202442416635	Sample description	ACTIVE	100620244241	\N
1006202442437153	Sample description	ACTIVE	100620244243	\N
1006202742486687	Sample description	ACTIVE	100620274248	\N
1006202742486245	Sample description	ACTIVE	100620274248	\N
1006202742496548	Sample description	ACTIVE	100620274249	\N
1006202742466927	Sample description	ACTIVE	100620274246	\N
1006202742466434	Sample description	ACTIVE	100620274246	\N
1006202742506890	Sample description	ACTIVE	100620274250	\N
1006202742446335	Sample description	ACTIVE	100620274244	\N
1006202742526926	Sample description	ACTIVE	100620274252	\N
1006202742536350	Sample description	ACTIVE	100620274253	\N
1006202742537227	Sample description	ACTIVE	100620274253	\N
1006202742536488	Sample description	ACTIVE	100620274253	\N
1006202742536462	Sample description	ACTIVE	100620274253	\N
1006202742537077	Sample description	ACTIVE	100620274253	\N
1006202742537439	Sample description	ACTIVE	100620274253	\N
1006202742536758	Sample description	ACTIVE	100620274253	\N
1006202742536490	Sample description	ACTIVE	100620274253	\N
1006202740626555	Sample description	ACTIVE	100620274062	\N
1006202742547228	Sample description	ACTIVE	100620274254	\N
1006202742547229	Sample description	ACTIVE	100620274254	\N
1006202742547230	Sample description	ACTIVE	100620274254	\N
1006202742547231	Sample description	ACTIVE	100620274254	\N
1006202742547232	Sample description	ACTIVE	100620274254	\N
1006202742547233	Sample description	ACTIVE	100620274254	\N
1006202742547078	Sample description	ACTIVE	100620274254	\N
1006202742547492	Sample description	ACTIVE	100620274254	\N
1006202742547264	Sample description	ACTIVE	100620274254	\N
1006202742547265	Sample description	ACTIVE	100620274254	\N
1006202742547266	Sample description	ACTIVE	100620274254	\N
1006202742547267	Sample description	ACTIVE	100620274254	\N
1006202742547269	Sample description	ACTIVE	100620274254	\N
1006202742547268	Sample description	ACTIVE	100620274254	\N
1006202742547256	Sample description	ACTIVE	100620274254	\N
1006202742547257	Sample description	ACTIVE	100620274254	\N
1006202742547258	Sample description	ACTIVE	100620274254	\N
1006202742547259	Sample description	ACTIVE	100620274254	\N
1006202742547260	Sample description	ACTIVE	100620274254	\N
1006202742547263	Sample description	ACTIVE	100620274254	\N
1006202742547249	Sample description	ACTIVE	100620274254	\N
1006202742547250	Sample description	ACTIVE	100620274254	\N
1006202742547252	Sample description	ACTIVE	100620274254	\N
1006202742547253	Sample description	ACTIVE	100620274254	\N
1006202742547254	Sample description	ACTIVE	100620274254	\N
1006202742547255	Sample description	ACTIVE	100620274254	\N
1006202742547244	Sample description	ACTIVE	100620274254	\N
1006202742547245	Sample description	ACTIVE	100620274254	\N
1006202742547246	Sample description	ACTIVE	100620274254	\N
1006202742547247	Sample description	ACTIVE	100620274254	\N
1006202742547248	Sample description	ACTIVE	100620274254	\N
1006202742547251	Sample description	ACTIVE	100620274254	\N
1006202742547235	Sample description	ACTIVE	100620274254	\N
1006202742547236	Sample description	ACTIVE	100620274254	\N
1006202742547240	Sample description	ACTIVE	100620274254	\N
1006202742547241	Sample description	ACTIVE	100620274254	\N
1006202742547242	Sample description	ACTIVE	100620274254	\N
1006202742547243	Sample description	ACTIVE	100620274254	\N
1006202742456044	Sample description	ACTIVE	100620274245	\N
1006202742456045	Sample description	ACTIVE	100620274245	\N
1006202742456046	Sample description	ACTIVE	100620274245	\N
1006202742456047	Sample description	ACTIVE	100620274245	\N
1006202742456049	Sample description	ACTIVE	100620274245	\N
1006202742456050	Sample description	ACTIVE	100620274245	\N
1006202742456679	Sample description	ACTIVE	100620274245	\N
1006202742456681	Sample description	ACTIVE	100620274245	\N
1006202742456682	Sample description	ACTIVE	100620274245	\N
1006202742456683	Sample description	ACTIVE	100620274245	\N
1006202742456684	Sample description	ACTIVE	100620274245	\N
1006202742457148	Sample description	ACTIVE	100620274245	\N
1006202742456342	Sample description	ACTIVE	100620274245	\N
1006202742456674	Sample description	ACTIVE	100620274245	\N
1006202742456675	Sample description	ACTIVE	100620274245	\N
1006202742456676	Sample description	ACTIVE	100620274245	\N
1006202742456677	Sample description	ACTIVE	100620274245	\N
1006202742456678	Sample description	ACTIVE	100620274245	\N
1006202742456333	Sample description	ACTIVE	100620274245	\N
1006202742456334	Sample description	ACTIVE	100620274245	\N
1006202742456338	Sample description	ACTIVE	100620274245	\N
1006202742456339	Sample description	ACTIVE	100620274245	\N
1006202742456340	Sample description	ACTIVE	100620274245	\N
1006202742456341	Sample description	ACTIVE	100620274245	\N
1006202742456325	Sample description	ACTIVE	100620274245	\N
1006202742456326	Sample description	ACTIVE	100620274245	\N
1006202742456327	Sample description	ACTIVE	100620274245	\N
1006202742456329	Sample description	ACTIVE	100620274245	\N
1006202742456330	Sample description	ACTIVE	100620274245	\N
1006202742456332	Sample description	ACTIVE	100620274245	\N
1006202742456249	Sample description	ACTIVE	100620274245	\N
1006202742456250	Sample description	ACTIVE	100620274245	\N
1006202742456252	Sample description	ACTIVE	100620274245	\N
1006202742456253	Sample description	ACTIVE	100620274245	\N
1006202742456321	Sample description	ACTIVE	100620274245	\N
1006202742456322	Sample description	ACTIVE	100620274245	\N
1006202742456051	Sample description	ACTIVE	100620274245	\N
1006202742456052	Sample description	ACTIVE	100620274245	\N
1006202742456053	Sample description	ACTIVE	100620274245	\N
1006202742456055	Sample description	ACTIVE	100620274245	\N
1006202742456242	Sample description	ACTIVE	100620274245	\N
1006202742456248	Sample description	ACTIVE	100620274245	\N
1006202742517440	Sample description	ACTIVE	100620274251	\N
1006202742517071	Sample description	ACTIVE	100620274251	\N
1006202742516868	Sample description	ACTIVE	100620274251	\N
1006202742516860	Sample description	ACTIVE	100620274251	\N
1006202742516861	Sample description	ACTIVE	100620274251	\N
1006202742516862	Sample description	ACTIVE	100620274251	\N
1006202742516863	Sample description	ACTIVE	100620274251	\N
1006202742516864	Sample description	ACTIVE	100620274251	\N
1006202742516865	Sample description	ACTIVE	100620274251	\N
1006202742516866	Sample description	ACTIVE	100620274251	\N
1006202742516869	Sample description	ACTIVE	100620274251	\N
1006202742516871	Sample description	ACTIVE	100620274251	\N
1006207942586818	Sample description	ACTIVE	100620794258	\N
1006207942606752	Sample description	ACTIVE	100620794260	\N
1006207942606983	Sample description	ACTIVE	100620794260	\N
1006207942627280	Sample description	ACTIVE	100620794262	\N
1006207942627281	Sample description	ACTIVE	100620794262	\N
1006207942627285	Sample description	ACTIVE	100620794262	\N
1006207942627286	Sample description	ACTIVE	100620794262	\N
1006207942627287	Sample description	ACTIVE	100620794262	\N
1006207942627282	Sample description	ACTIVE	100620794262	\N
1006207942627288	Sample description	ACTIVE	100620794262	\N
1006207942627289	Sample description	ACTIVE	100620794262	\N
1006207942596794	Sample description	ACTIVE	100620794259	\N
1006207942596795	Sample description	ACTIVE	100620794259	\N
1006207942597497	Sample description	ACTIVE	100620794259	\N
1006207942597477	Sample description	ACTIVE	100620794259	\N
1006207942596797	Sample description	ACTIVE	100620794259	\N
1006207942596803	Sample description	ACTIVE	100620794259	\N
1006207942597496	Sample description	ACTIVE	100620794259	\N
1006207942596811	Sample description	ACTIVE	100620794259	\N
1006207942596814	Sample description	ACTIVE	100620794259	\N
1006207942596815	Sample description	ACTIVE	100620794259	\N
1006207942596816	Sample description	ACTIVE	100620794259	\N
1006207942596817	Sample description	ACTIVE	100620794259	\N
1006207942596819	Sample description	ACTIVE	100620794259	\N
1006207942596806	Sample description	ACTIVE	100620794259	\N
1006207942596807	Sample description	ACTIVE	100620794259	\N
1006207942597476	Sample description	ACTIVE	100620794259	\N
1006207942596825	Sample description	ACTIVE	100620794259	\N
1006207942596809	Sample description	ACTIVE	100620794259	\N
1006207942596813	Sample description	ACTIVE	100620794259	\N
1006207942596796	Sample description	ACTIVE	100620794259	\N
1006207942596799	Sample description	ACTIVE	100620794259	\N
1006207942596800	Sample description	ACTIVE	100620794259	\N
1006207942596802	Sample description	ACTIVE	100620794259	\N
1006207942596804	Sample description	ACTIVE	100620794259	\N
1006207942596805	Sample description	ACTIVE	100620794259	\N
1006207942616751	Sample description	ACTIVE	100620794261	\N
1006207942616978	Sample description	ACTIVE	100620794261	\N
1006207942616979	Sample description	ACTIVE	100620794261	\N
1006207942616982	Sample description	ACTIVE	100620794261	\N
1006207942616981	Sample description	ACTIVE	100620794261	\N
1006207942616980	Sample description	ACTIVE	100620794261	\N
1006207942617465	Sample description	ACTIVE	100620794261	\N
1006204243877455	Sample description	ACTIVE	100620424387	\N
1006204242636310	Sample description	ACTIVE	100620424263	\N
1006204242667346	Sample description	ACTIVE	100620424266	\N
1006204242656971	Sample description	ACTIVE	100620424265	\N
1006204242656972	Sample description	ACTIVE	100620424265	\N
1006204242647370	Sample description	ACTIVE	100620424264	\N
1006204242677347	Sample description	ACTIVE	100620424267	\N
1006204242677353	Sample description	ACTIVE	100620424267	\N
1006204342707026	Sample description	ACTIVE	100620434270	\N
1006204341157052	Sample description	ACTIVE	100620434115	\N
1006204341157055	Sample description	ACTIVE	100620434115	\N
1006204342687027	Sample description	ACTIVE	100620434268	\N
1006204342697053	Sample description	ACTIVE	100620434269	\N
1006204442717062	Sample description	ACTIVE	100620444271	\N
1006204442717068	Sample description	ACTIVE	100620444271	\N
1006204442727197	Sample description	ACTIVE	100620444272	\N
1006204443867044	Sample description	ACTIVE	100620444386	\N
1006204442767056	Sample description	ACTIVE	100620444276	\N
1006204442767063	Sample description	ACTIVE	100620444276	\N
1006204442767064	Sample description	ACTIVE	100620444276	\N
1006204442766867	Sample description	ACTIVE	100620444276	\N
1006204442767065	Sample description	ACTIVE	100620444276	\N
1006204442767069	Sample description	ACTIVE	100620444276	\N
1006204442767070	Sample description	ACTIVE	100620444276	\N
1006204442747046	Sample description	ACTIVE	100620444274	\N
1006204442747045	Sample description	ACTIVE	100620444274	\N
1006204442747047	Sample description	ACTIVE	100620444274	\N
1006204442747048	Sample description	ACTIVE	100620444274	\N
1006204442747049	Sample description	ACTIVE	100620444274	\N
1006204442747050	Sample description	ACTIVE	100620444274	\N
1006207443807099	Sample description	ACTIVE	100620744380	\N
1006207442257435	Sample description	ACTIVE	100620744225	\N
1006207441866141	Sample description	ACTIVE	100620744186	\N
1006207441867436	Sample description	ACTIVE	100620744186	\N
1006207442237491	Sample description	ACTIVE	100620744223	\N
1006207442237480	Sample description	ACTIVE	100620744223	\N
1006207442237479	Sample description	ACTIVE	100620744223	\N
1006207442237478	Sample description	ACTIVE	100620744223	\N
1006207442237081	Sample description	ACTIVE	100620744223	\N
1006207442237095	Sample description	ACTIVE	100620744223	\N
1006207442236588	Sample description	ACTIVE	100620744223	\N
1006207442236589	Sample description	ACTIVE	100620744223	\N
1006207442237096	Sample description	ACTIVE	100620744223	\N
1006207442237097	Sample description	ACTIVE	100620744223	\N
1006207442237098	Sample description	ACTIVE	100620744223	\N
1006207442237088	Sample description	ACTIVE	100620744223	\N
1006207442237089	Sample description	ACTIVE	100620744223	\N
1006207442237090	Sample description	ACTIVE	100620744223	\N
1006207442237091	Sample description	ACTIVE	100620744223	\N
1006207442237092	Sample description	ACTIVE	100620744223	\N
1006207442237093	Sample description	ACTIVE	100620744223	\N
1006207442237082	Sample description	ACTIVE	100620744223	\N
1006207442237083	Sample description	ACTIVE	100620744223	\N
1006207442237084	Sample description	ACTIVE	100620744223	\N
1006207442237085	Sample description	ACTIVE	100620744223	\N
1006207442236587	Sample description	ACTIVE	100620744223	\N
1006207442237086	Sample description	ACTIVE	100620744223	\N
1006208042777128	Sample description	ACTIVE	100620804277	\N
1006208042797135	Sample description	ACTIVE	100620804279	\N
1006208043777132	Sample description	ACTIVE	100620804377	\N
1006208042807137	Sample description	ACTIVE	100620804280	\N
1006208042817138	Sample description	ACTIVE	100620804281	\N
1006208042817142	Sample description	ACTIVE	100620804281	\N
1006208041437394	Sample description	ACTIVE	100620804143	\N
1006207642346591	Sample description	ACTIVE	100620764234	\N
1006207642357210	Sample description	ACTIVE	100620764235	\N
1006207642367226	Sample description	ACTIVE	100620764236	\N
1006207642336598	Sample description	ACTIVE	100620764233	\N
1006207642336597	Sample description	ACTIVE	100620764233	\N
1006207642336599	Sample description	ACTIVE	100620764233	\N
1006207642336600	Sample description	ACTIVE	100620764233	\N
1006207642336601	Sample description	ACTIVE	100620764233	\N
1006207642336604	Sample description	ACTIVE	100620764233	\N
1006207642336603	Sample description	ACTIVE	100620764233	\N
1006207642336605	Sample description	ACTIVE	100620764233	\N
1006207642336606	Sample description	ACTIVE	100620764233	\N
1006207642336609	Sample description	ACTIVE	100620764233	\N
1006207642336610	Sample description	ACTIVE	100620764233	\N
1006208142826315	Sample description	ACTIVE	100620814282	\N
1006208142826314	Sample description	ACTIVE	100620814282	\N
1006208142847351	Sample description	ACTIVE	100620814284	\N
1006208142847354	Sample description	ACTIVE	100620814284	\N
1006208142837339	Sample description	ACTIVE	100620814283	\N
1006208143787076	Sample description	ACTIVE	100620814378	\N
1006208242877337	Sample description	ACTIVE	100620824287	\N
1006208242857367	Sample description	ACTIVE	100620824285	\N
1006208242867368	Sample description	ACTIVE	100620824286	\N
1006205840326308	Sample description	ACTIVE	100620584032	\N
1006205840326309	Sample description	ACTIVE	100620584032	\N
1006205840326316	Sample description	ACTIVE	100620584032	\N
1006205840327335	Sample description	ACTIVE	100620584032	\N
1006205840316311	Sample description	ACTIVE	100620584031	\N
1006205840316312	Sample description	ACTIVE	100620584031	\N
1006205840316313	Sample description	ACTIVE	100620584031	\N
1006205840296307	Sample description	ACTIVE	100620584029	\N
1006205841397344	Sample description	ACTIVE	100620584139	\N
1006205841397345	Sample description	ACTIVE	100620584139	\N
1006205841397355	Sample description	ACTIVE	100620584139	\N
1006205841387349	Sample description	ACTIVE	100620584138	\N
1006205841387350	Sample description	ACTIVE	100620584138	\N
1006205841367342	Sample description	ACTIVE	100620584136	\N
1006205841367343	Sample description	ACTIVE	100620584136	\N
1000208342886057	Sample description	ACTIVE	100020834288	\N
1000208342886076	Sample description	ACTIVE	100020834288	\N
1000208342886082	Sample description	ACTIVE	100020834288	\N
1000208342886083	Sample description	ACTIVE	100020834288	\N
1000208342886084	Sample description	ACTIVE	100020834288	\N
1000208342886224	Sample description	ACTIVE	100020834288	\N
1000208342886259	Sample description	ACTIVE	100020834288	\N
1000208342886437	Sample description	ACTIVE	100020834288	\N
1000208342886450	Sample description	ACTIVE	100020834288	\N
1000208342886753	Sample description	ACTIVE	100020834288	\N
1000208342887168	Sample description	ACTIVE	100020834288	\N
1000208340036062	Sample description	ACTIVE	100020834003	\N
1000208340036063	Sample description	ACTIVE	100020834003	\N
1000208340036064	Sample description	ACTIVE	100020834003	\N
1000208340036066	Sample description	ACTIVE	100020834003	\N
1000208340036067	Sample description	ACTIVE	100020834003	\N
1000208340036065	Sample description	ACTIVE	100020834003	\N
1000208340037433	Sample description	ACTIVE	100020834003	\N
1000208340666573	Sample description	ACTIVE	100020834066	\N
1000208340666574	Sample description	ACTIVE	100020834066	\N
1000208340666575	Sample description	ACTIVE	100020834066	\N
1000208340666576	Sample description	ACTIVE	100020834066	\N
1000208340667154	Sample description	ACTIVE	100020834066	\N
1000208340956780	Sample description	ACTIVE	100020834095	\N
1000208340956781	Sample description	ACTIVE	100020834095	\N
1000208340956782	Sample description	ACTIVE	100020834095	\N
1000208340956783	Sample description	ACTIVE	100020834095	\N
1000208340956784	Sample description	ACTIVE	100020834095	\N
1000208342906873	Sample description	ACTIVE	100020834290	\N
1000208342897508	Sample description	ACTIVE	100020834289	\N
1000208342896877	Sample description	ACTIVE	100020834289	\N
1000208342896878	Sample description	ACTIVE	100020834289	\N
1000208342896879	Sample description	ACTIVE	100020834289	\N
1000208342896881	Sample description	ACTIVE	100020834289	\N
1000208342897161	Sample description	ACTIVE	100020834289	\N
1000208341146301	Sample description	ACTIVE	100020834114	\N
1000208341146494	Sample description	ACTIVE	100020834114	\N
1000208341146874	Sample description	ACTIVE	100020834114	\N
1000208341146875	Sample description	ACTIVE	100020834114	\N
1000208341147043	Sample description	ACTIVE	100020834114	\N
1000208341147113	Sample description	ACTIVE	100020834114	\N
1000208341147352	Sample description	ACTIVE	100020834114	\N
1000208341146058	Sample description	ACTIVE	100020834114	\N
1000211240066072	Sample description	ACTIVE	100021124006	\N
1000211240066672	Sample description	ACTIVE	100021124006	\N
1000211240066673	Sample description	ACTIVE	100021124006	\N
1000211240067031	Sample description	ACTIVE	100021124006	\N
1000211240846742	Sample description	ACTIVE	100021124084	\N
1000208642916787	Sample description	ACTIVE	100020864291	\N
1000208642916788	Sample description	ACTIVE	100020864291	\N
1000208642927157	Sample description	ACTIVE	100020864292	\N
1000208642937158	Sample description	ACTIVE	100020864293	\N
1000208642957159	Sample description	ACTIVE	100020864295	\N
1000208642947160	Sample description	ACTIVE	100020864294	\N
1000208540087429	Sample description	ACTIVE	100020854008	\N
1000208540086406	Sample description	ACTIVE	100020854008	\N
1000208540086500	Sample description	ACTIVE	100020854008	\N
1000208540086608	Sample description	ACTIVE	100020854008	\N
1000208540086759	Sample description	ACTIVE	100020854008	\N
1000208540086778	Sample description	ACTIVE	100020854008	\N
1000208540086832	Sample description	ACTIVE	100020854008	\N
1000200540226094	Sample description	ACTIVE	100020054022	\N
1000200540226260	Sample description	ACTIVE	100020054022	\N
1000200540227329	Sample description	ACTIVE	100020054022	\N
1000200540227391	Sample description	ACTIVE	100020054022	\N
1000200540227397	Sample description	ACTIVE	100020054022	\N
1000200540376081	Sample description	ACTIVE	100020054037	\N
1000200540376421	Sample description	ACTIVE	100020054037	\N
1000200540377392	Sample description	ACTIVE	100020054037	\N
1000208742966300	Sample description	ACTIVE	100020874296	\N
1000208742987162	Sample description	ACTIVE	100020874298	\N
1000208743007300	Sample description	ACTIVE	100020874300	\N
1000208743857302	Sample description	ACTIVE	100020874385	\N
1000208742977509	Sample description	ACTIVE	100020874297	\N
1000208742977511	Sample description	ACTIVE	100020874297	\N
1000208742977514	Sample description	ACTIVE	100020874297	\N
1000208742977512	Sample description	ACTIVE	100020874297	\N
1000208742977513	Sample description	ACTIVE	100020874297	\N
1000208742976303	Sample description	ACTIVE	100020874297	\N
1000208742997163	Sample description	ACTIVE	100020874299	\N
1000208742997164	Sample description	ACTIVE	100020874299	\N
1000208742997165	Sample description	ACTIVE	100020874299	\N
1000208742997166	Sample description	ACTIVE	100020874299	\N
1000208742997167	Sample description	ACTIVE	100020874299	\N
1000208743847301	Sample description	ACTIVE	100020874384	\N
1000208743847307	Sample description	ACTIVE	100020874384	\N
1000208743847303	Sample description	ACTIVE	100020874384	\N
1000208743847304	Sample description	ACTIVE	100020874384	\N
1000208743847305	Sample description	ACTIVE	100020874384	\N
1000208743847306	Sample description	ACTIVE	100020874384	\N
1000208743847308	Sample description	ACTIVE	100020874384	\N
1000208743847309	Sample description	ACTIVE	100020874384	\N
1000208743847310	Sample description	ACTIVE	100020874384	\N
1000208743847311	Sample description	ACTIVE	100020874384	\N
1000208743846085	Sample description	ACTIVE	100020874384	\N
1000208843026373	Sample description	ACTIVE	100020884302	\N
1000208843827446	Sample description	ACTIVE	100020884382	\N
1000208843827442	Sample description	ACTIVE	100020884382	\N
1000208843827445	Sample description	ACTIVE	100020884382	\N
1000208843827444	Sample description	ACTIVE	100020884382	\N
1000208843827443	Sample description	ACTIVE	100020884382	\N
1000208843827466	Sample description	ACTIVE	100020884382	\N
1000208843046650	Sample description	ACTIVE	100020884304	\N
1000208843076658	Sample description	ACTIVE	100020884307	\N
1000208843087377	Sample description	ACTIVE	100020884308	\N
1000208843036374	Sample description	ACTIVE	100020884303	\N
1000208843036375	Sample description	ACTIVE	100020884303	\N
1000208843036376	Sample description	ACTIVE	100020884303	\N
1000208843036377	Sample description	ACTIVE	100020884303	\N
1000208843036379	Sample description	ACTIVE	100020884303	\N
1000208843036380	Sample description	ACTIVE	100020884303	\N
1000208843036386	Sample description	ACTIVE	100020884303	\N
1000208843036387	Sample description	ACTIVE	100020884303	\N
1000208843036378	Sample description	ACTIVE	100020884303	\N
1000208843036382	Sample description	ACTIVE	100020884303	\N
1000208843036381	Sample description	ACTIVE	100020884303	\N
1000208843037517	Sample description	ACTIVE	100020884303	\N
1000208843036383	Sample description	ACTIVE	100020884303	\N
1000208843036384	Sample description	ACTIVE	100020884303	\N
1000208843036385	Sample description	ACTIVE	100020884303	\N
1000208843056651	Sample description	ACTIVE	100020884305	\N
1000208843067518	Sample description	ACTIVE	100020884306	\N
1000208843066652	Sample description	ACTIVE	100020884306	\N
1000208843066653	Sample description	ACTIVE	100020884306	\N
1000208843797482	Sample description	ACTIVE	100020884379	\N
1000208843797432	Sample description	ACTIVE	100020884379	\N
1000208843797484	Sample description	ACTIVE	100020884379	\N
1000208841257125	Sample description	ACTIVE	100020884125	\N
1000208841257126	Sample description	ACTIVE	100020884125	\N
1000208841257127	Sample description	ACTIVE	100020884125	\N
1000211140486457	Sample description	ACTIVE	100021114048	\N
1000211140486451	Sample description	ACTIVE	100021114048	\N
1000211140486452	Sample description	ACTIVE	100021114048	\N
1000211140486453	Sample description	ACTIVE	100021114048	\N
1000211140486454	Sample description	ACTIVE	100021114048	\N
1000211140486455	Sample description	ACTIVE	100021114048	\N
1000211140486456	Sample description	ACTIVE	100021114048	\N
1000208940786708	Sample description	ACTIVE	100020894078	\N
1000208940786709	Sample description	ACTIVE	100020894078	\N
1000208940786710	Sample description	ACTIVE	100020894078	\N
1000208941337324	Sample description	ACTIVE	100020894133	\N
1000208941337327	Sample description	ACTIVE	100020894133	\N
1000208941337326	Sample description	ACTIVE	100020894133	\N
1000208941337328	Sample description	ACTIVE	100020894133	\N
1000209143156619	Sample description	ACTIVE	100020914315	\N
1000209143227204	Sample description	ACTIVE	100020914322	\N
1000209143196612	Sample description	ACTIVE	100020914319	\N
1000209143206061	Sample description	ACTIVE	100020914320	\N
1000209143217395	Sample description	ACTIVE	100020914321	\N
1000209143236726	Sample description	ACTIVE	100020914323	\N
1000209143236725	Sample description	ACTIVE	100020914323	\N
1000209143236722	Sample description	ACTIVE	100020914323	\N
1000209143236723	Sample description	ACTIVE	100020914323	\N
1000209143236965	Sample description	ACTIVE	100020914323	\N
1000209143236962	Sample description	ACTIVE	100020914323	\N
1000209143236554	Sample description	ACTIVE	100020914323	\N
1000209143236963	Sample description	ACTIVE	100020914323	\N
1000209143236964	Sample description	ACTIVE	100020914323	\N
1000209143236719	Sample description	ACTIVE	100020914323	\N
1000209143236724	Sample description	ACTIVE	100020914323	\N
1000209143236069	Sample description	ACTIVE	100020914323	\N
1000209143236070	Sample description	ACTIVE	100020914323	\N
1000209143236225	Sample description	ACTIVE	100020914323	\N
1000209143236463	Sample description	ACTIVE	100020914323	\N
1000209143186068	Sample description	ACTIVE	100020914318	\N
1000209143166071	Sample description	ACTIVE	100020914316	\N
1000209141076933	Sample description	ACTIVE	100020914107	\N
1000209141076937	Sample description	ACTIVE	100020914107	\N
1000209141076934	Sample description	ACTIVE	100020914107	\N
1000209141076935	Sample description	ACTIVE	100020914107	\N
1000209141076936	Sample description	ACTIVE	100020914107	\N
1000203240856021	Sample description	ACTIVE	100020324085	\N
1000203240856077	Sample description	ACTIVE	100020324085	\N
1000203240856318	Sample description	ACTIVE	100020324085	\N
1000203240856344	Sample description	ACTIVE	100020324085	\N
1000203240856351	Sample description	ACTIVE	100020324085	\N
1000203240856389	Sample description	ACTIVE	100020324085	\N
1000203240857129	Sample description	ACTIVE	100020324085	\N
1000203240857217	Sample description	ACTIVE	100020324085	\N
1000203240857294	Sample description	ACTIVE	100020324085	\N
1000203240857296	Sample description	ACTIVE	100020324085	\N
1000203240856698	Sample description	ACTIVE	100020324085	\N
1000203240856707	Sample description	ACTIVE	100020324085	\N
1000203240856720	Sample description	ACTIVE	100020324085	\N
1000203240856741	Sample description	ACTIVE	100020324085	\N
1000203240856746	Sample description	ACTIVE	100020324085	\N
1000203240856872	Sample description	ACTIVE	100020324085	\N
1000203240856405	Sample description	ACTIVE	100020324085	\N
1000203240856447	Sample description	ACTIVE	100020324085	\N
1000203240856448	Sample description	ACTIVE	100020324085	\N
1000203240856449	Sample description	ACTIVE	100020324085	\N
1000203240856497	Sample description	ACTIVE	100020324085	\N
1000203240856501	Sample description	ACTIVE	100020324085	\N
1000204043286464	Sample description	ACTIVE	100020404328	\N
1000204043296091	Sample description	ACTIVE	100020404329	\N
1000204043307196	Sample description	ACTIVE	100020404330	\N
1000204043256700	Sample description	ACTIVE	100020404325	\N
1000204043266699	Sample description	ACTIVE	100020404326	\N
1000204043267519	Sample description	ACTIVE	100020404326	\N
1000204043276701	Sample description	ACTIVE	100020404327	\N
1000204043276702	Sample description	ACTIVE	100020404327	\N
1000204043246838	Sample description	ACTIVE	100020404324	\N
1000204043346845	Sample description	ACTIVE	100020404334	\N
1000204043346846	Sample description	ACTIVE	100020404334	\N
1000204043346847	Sample description	ACTIVE	100020404334	\N
1000204043346849	Sample description	ACTIVE	100020404334	\N
1000204043346850	Sample description	ACTIVE	100020404334	\N
1000204043346842	Sample description	ACTIVE	100020404334	\N
1000204043346851	Sample description	ACTIVE	100020404334	\N
1000204043346852	Sample description	ACTIVE	100020404334	\N
1000204043346853	Sample description	ACTIVE	100020404334	\N
1000204043346843	Sample description	ACTIVE	100020404334	\N
1000204043346844	Sample description	ACTIVE	100020404334	\N
1000204043347510	Sample description	ACTIVE	100020404334	\N
1000204043346840	Sample description	ACTIVE	100020404334	\N
1000204043326848	Sample description	ACTIVE	100020404332	\N
1000204043316841	Sample description	ACTIVE	100020404331	\N
1000204043337366	Sample description	ACTIVE	100020404333	\N
1000204043337369	Sample description	ACTIVE	100020404333	\N
1000204043337371	Sample description	ACTIVE	100020404333	\N
1000209043096992	Sample description	ACTIVE	100020904309	\N
1000209043117312	Sample description	ACTIVE	100020904311	\N
1000209043146985	Sample description	ACTIVE	100020904314	\N
1000209043146987	Sample description	ACTIVE	100020904314	\N
1000209043146991	Sample description	ACTIVE	100020904314	\N
1000209043146988	Sample description	ACTIVE	100020904314	\N
1000209043146989	Sample description	ACTIVE	100020904314	\N
1000209043146990	Sample description	ACTIVE	100020904314	\N
1000209043127314	Sample description	ACTIVE	100020904312	\N
1000209043127318	Sample description	ACTIVE	100020904312	\N
1000209043127320	Sample description	ACTIVE	100020904312	\N
1000209043127321	Sample description	ACTIVE	100020904312	\N
1000209043127322	Sample description	ACTIVE	100020904312	\N
1000209043127323	Sample description	ACTIVE	100020904312	\N
1000204543356092	Sample description	ACTIVE	100020454335	\N
1000204543417072	Sample description	ACTIVE	100020454341	\N
1000204543417358	Sample description	ACTIVE	100020454341	\N
1000204543417359	Sample description	ACTIVE	100020454341	\N
1000204543417361	Sample description	ACTIVE	100020454341	\N
1000204543366728	Sample description	ACTIVE	100020454336	\N
1000204543376727	Sample description	ACTIVE	100020454337	\N
1000204543397054	Sample description	ACTIVE	100020454339	\N
1000204543387075	Sample description	ACTIVE	100020454338	\N
1000204543407357	Sample description	ACTIVE	100020454340	\N
1000207341707414	Sample description	ACTIVE	100020734170	\N
1000207341417379	Sample description	ACTIVE	100020734141	\N
1000207341417386	Sample description	ACTIVE	100020734141	\N
1000207341417387	Sample description	ACTIVE	100020734141	\N
1000207341417389	Sample description	ACTIVE	100020734141	\N
1000207341426409	Sample description	ACTIVE	100020734142	\N
1000207341427382	Sample description	ACTIVE	100020734142	\N
1000207341427383	Sample description	ACTIVE	100020734142	\N
1000207341427384	Sample description	ACTIVE	100020734142	\N
1000207341427385	Sample description	ACTIVE	100020734142	\N
1000207341427388	Sample description	ACTIVE	100020734142	\N
1000207341407381	Sample description	ACTIVE	100020734140	\N
1000207341717415	Sample description	ACTIVE	100020734171	\N
1000207341717417	Sample description	ACTIVE	100020734171	\N
1000207341717418	Sample description	ACTIVE	100020734171	\N
1000207341717419	Sample description	ACTIVE	100020734171	\N
1000207341717416	Sample description	ACTIVE	100020734171	\N
1000207341717420	Sample description	ACTIVE	100020734171	\N
1000207341717421	Sample description	ACTIVE	100020734171	\N
1000207341717422	Sample description	ACTIVE	100020734171	\N
1000207341717423	Sample description	ACTIVE	100020734171	\N
1000207341717424	Sample description	ACTIVE	100020734171	\N
1003202840776705	Sample description	ACTIVE	100320284077	\N
1003202840777202	Sample description	ACTIVE	100320284077	\N
1003202840777212	Sample description	ACTIVE	100320284077	\N
1003202840777428	Sample description	ACTIVE	100320284077	\N
1003202840776740	Sample description	ACTIVE	100320284077	\N
1003202840776835	Sample description	ACTIVE	100320284077	\N
1003202840776370	Sample description	ACTIVE	100320284077	\N
1003202840776025	Sample description	ACTIVE	100320284077	\N
1003202840777373	Sample description	ACTIVE	100320284077	\N
1003202840776704	Sample description	ACTIVE	100320284077	\N
1003202840777200	Sample description	ACTIVE	100320284077	\N
1003202840777198	Sample description	ACTIVE	100320284077	\N
1003204841227112	Sample description	ACTIVE	100320484122	\N
1003204841226079	Sample description	ACTIVE	100320484122	\N
1003204841227111	Sample description	ACTIVE	100320484122	\N
1003204841226715	Sample description	ACTIVE	100320484122	\N
1003204841227109	Sample description	ACTIVE	100320484122	\N
1003204841227219	Sample description	ACTIVE	100320484122	\N
1003204841227117	Sample description	ACTIVE	100320484122	\N
1003204841226078	Sample description	ACTIVE	100320484122	\N
1003204841227270	Sample description	ACTIVE	100320484122	\N
1003204841226080	Sample description	ACTIVE	100320484122	\N
1003204841226714	Sample description	ACTIVE	100320484122	\N
1003204841226718	Sample description	ACTIVE	100320484122	\N
1003204841226786	Sample description	ACTIVE	100320484122	\N
1003201940636558	Sample description	ACTIVE	100320194063	\N
1003201940636557	Sample description	ACTIVE	100320194063	\N
1003204941237121	Sample description	ACTIVE	100320494123	\N
1003205541347332	Sample description	ACTIVE	100320554134	\N
1003205541347333	Sample description	ACTIVE	100320554134	\N
1003205541347201	Sample description	ACTIVE	100320554134	\N
1003205541347390	Sample description	ACTIVE	100320554134	\N
1003205541347331	Sample description	ACTIVE	100320554134	\N
1003204141046883	Sample description	ACTIVE	100320414104	\N
1003204141046884	Sample description	ACTIVE	100320414104	\N
1003204141046885	Sample description	ACTIVE	100320414104	\N
1003202340706611	Sample description	ACTIVE	100320234070	\N
1003202340706372	Sample description	ACTIVE	100320234070	\N
1003202340706618	Sample description	ACTIVE	100320234070	\N
1003202340706059	Sample description	ACTIVE	100320234070	\N
1003202340706438	Sample description	ACTIVE	100320234070	\N
1003202340706755	Sample description	ACTIVE	100320234070	\N
1003205241277178	Sample description	ACTIVE	100320524127	\N
1003205240656562	Sample description	ACTIVE	100320524065	\N
1003205241287169	Sample description	ACTIVE	100320524128	\N
1003205241287170	Sample description	ACTIVE	100320524128	\N
1003205241287171	Sample description	ACTIVE	100320524128	\N
1003205241287173	Sample description	ACTIVE	100320524128	\N
1003205241287174	Sample description	ACTIVE	100320524128	\N
1003205241287175	Sample description	ACTIVE	100320524128	\N
1003205240646559	Sample description	ACTIVE	100320524064	\N
1003205240646561	Sample description	ACTIVE	100320524064	\N
1003205240646560	Sample description	ACTIVE	100320524064	\N
1003203340866024	Sample description	ACTIVE	100320334086	\N
1003203340866073	Sample description	ACTIVE	100320334086	\N
1003203340866074	Sample description	ACTIVE	100320334086	\N
1003203340866756	Sample description	ACTIVE	100320334086	\N
1003203340866757	Sample description	ACTIVE	100320334086	\N
1003203340866785	Sample description	ACTIVE	100320334086	\N
1003203340867106	Sample description	ACTIVE	100320334086	\N
1003203340867218	Sample description	ACTIVE	100320334086	\N
1003203340867378	Sample description	ACTIVE	100320334086	\N
1003203340866130	Sample description	ACTIVE	100320334086	\N
1003203340867464	Sample description	ACTIVE	100320334086	\N
1003203340866441	Sample description	ACTIVE	100320334086	\N
1003203340866445	Sample description	ACTIVE	100320334086	\N
1003203340866716	Sample description	ACTIVE	100320334086	\N
1003203340866754	Sample description	ACTIVE	100320334086	\N
1004202640746655	Sample description	ACTIVE	100420264074	\N
1004202540737486	Sample description	ACTIVE	100420254073	\N
1004202540736656	Sample description	ACTIVE	100420254073	\N
1004202540736657	Sample description	ACTIVE	100420254073	\N
1004202540736659	Sample description	ACTIVE	100420254073	\N
1004202540736660	Sample description	ACTIVE	100420254073	\N
1004202540736662	Sample description	ACTIVE	100420254073	\N
1004202540736663	Sample description	ACTIVE	100420254073	\N
1004202540736664	Sample description	ACTIVE	100420254073	\N
1004202540736666	Sample description	ACTIVE	100420254073	\N
1004202540737507	Sample description	ACTIVE	100420254073	\N
1004203941006022	Sample description	ACTIVE	100420394100	\N
1004203941006056	Sample description	ACTIVE	100420394100	\N
1004203941006299	Sample description	ACTIVE	100420394100	\N
1004203941006440	Sample description	ACTIVE	100420394100	\N
1004203941006669	Sample description	ACTIVE	100420394100	\N
1004203941006712	Sample description	ACTIVE	100420394100	\N
1004203941006713	Sample description	ACTIVE	100420394100	\N
1004203941007030	Sample description	ACTIVE	100420394100	\N
1004203941007100	Sample description	ACTIVE	100420394100	\N
1004203941007114	Sample description	ACTIVE	100420394100	\N
1004203941007405	Sample description	ACTIVE	100420394100	\N
1007204741206095	Sample description	ACTIVE	100720474120	\N
1007204741206750	Sample description	ACTIVE	100720474120	\N
1007204741206976	Sample description	ACTIVE	100720474120	\N
1007204741207035	Sample description	ACTIVE	100720474120	\N
1007204741207102	Sample description	ACTIVE	100720474120	\N
1007204741207124	Sample description	ACTIVE	100720474120	\N
1007204741207283	Sample description	ACTIVE	100720474120	\N
1007204741207295	Sample description	ACTIVE	100720474120	\N
1007204641197107	Sample description	ACTIVE	100720464119	\N
1007204641196747	Sample description	ACTIVE	100720464119	\N
1007204641196977	Sample description	ACTIVE	100720464119	\N
1007204641196984	Sample description	ACTIVE	100720464119	\N
1007204641197101	Sample description	ACTIVE	100720464119	\N
1007204641197104	Sample description	ACTIVE	100720464119	\N
1007204641197105	Sample description	ACTIVE	100720464119	\N
1005201341596837	Sample description	ACTIVE	100520134159	\N
1005201341596408	Sample description	ACTIVE	100520134159	\N
1005201440497179	Sample description	ACTIVE	100520144049	\N
1005201440496298	Sample description	ACTIVE	100520144049	\N
1005201440496461	Sample description	ACTIVE	100520144049	\N
1005201440496737	Sample description	ACTIVE	100520144049	\N
1005201440497079	Sample description	ACTIVE	100520144049	\N
1005201440497149	Sample description	ACTIVE	100520144049	\N
1005201440497150	Sample description	ACTIVE	100520144049	\N
1005203441606745	Sample description	ACTIVE	100520344160	\N
1005206643817437	Sample description	ACTIVE	100520664381	\N
1005206641636442	Sample description	ACTIVE	100520664163	\N
1005206641616761	Sample description	ACTIVE	100520664161	\N
1005206641626763	Sample description	ACTIVE	100520664162	\N
1002205941466097	Sample description	ACTIVE	100220594146	\N
1002205941496736	Sample description	ACTIVE	100220594149	\N
1002205941486735	Sample description	ACTIVE	100220594148	\N
1002205941506836	Sample description	ACTIVE	100220594150	\N
1002205941517156	Sample description	ACTIVE	100220594151	\N
1002205941527410	Sample description	ACTIVE	100220594152	\N
1002205941527411	Sample description	ACTIVE	100220594152	\N
1002205941527374	Sample description	ACTIVE	100220594152	\N
1011210143506470	Sample description	ACTIVE	101121014350	\N
1011210143506471	Sample description	ACTIVE	101121014350	\N
1011210143506472	Sample description	ACTIVE	101121014350	\N
1011210143506474	Sample description	ACTIVE	101121014350	\N
1011210143506478	Sample description	ACTIVE	101121014350	\N
1011210143506480	Sample description	ACTIVE	101121014350	\N
1011210143506614	Sample description	ACTIVE	101121014350	\N
1011210143506615	Sample description	ACTIVE	101121014350	\N
1011210143506616	Sample description	ACTIVE	101121014350	\N
1011210143506617	Sample description	ACTIVE	101121014350	\N
1011209243426390	Sample description	ACTIVE	101120924342	\N
1011209243426305	Sample description	ACTIVE	101120924342	\N
1011209243426137	Sample description	ACTIVE	101120924342	\N
1011209243426264	Sample description	ACTIVE	101120924342	\N
1011209243426734	Sample description	ACTIVE	101120924342	\N
1011209243426789	Sample description	ACTIVE	101120924342	\N
1011209243426568	Sample description	ACTIVE	101120924342	\N
1011209243426790	Sample description	ACTIVE	101120924342	\N
1011209243426791	Sample description	ACTIVE	101120924342	\N
1011209243426567	Sample description	ACTIVE	101120924342	\N
1011209243426834	Sample description	ACTIVE	101120924342	\N
1011209243427025	Sample description	ACTIVE	101120924342	\N
1011209243426306	Sample description	ACTIVE	101120924342	\N
1011209243426263	Sample description	ACTIVE	101120924342	\N
1011209243426262	Sample description	ACTIVE	101120924342	\N
1011209443497460	Sample description	ACTIVE	101120944349	\N
1011209443497459	Sample description	ACTIVE	101120944349	\N
1011209443496102	Sample description	ACTIVE	101120944349	\N
1011209443496104	Sample description	ACTIVE	101120944349	\N
1011209443496107	Sample description	ACTIVE	101120944349	\N
1011209443496110	Sample description	ACTIVE	101120944349	\N
1011209443496127	Sample description	ACTIVE	101120944349	\N
1011209443496129	Sample description	ACTIVE	101120944349	\N
1011209443496113	Sample description	ACTIVE	101120944349	\N
1011209443496115	Sample description	ACTIVE	101120944349	\N
1011209443496117	Sample description	ACTIVE	101120944349	\N
1011209443496119	Sample description	ACTIVE	101120944349	\N
1011209443496125	Sample description	ACTIVE	101120944349	\N
1011209443496126	Sample description	ACTIVE	101120944349	\N
1011209440157485	Sample description	ACTIVE	101120944015	\N
1011209440156131	Sample description	ACTIVE	101120944015	\N
1011209440156132	Sample description	ACTIVE	101120944015	\N
1011209440156188	Sample description	ACTIVE	101120944015	\N
1011209440156189	Sample description	ACTIVE	101120944015	\N
1011209440156143	Sample description	ACTIVE	101120944015	\N
1011209440156689	Sample description	ACTIVE	101120944015	\N
1011209440157452	Sample description	ACTIVE	101120944015	\N
1011209440157500	Sample description	ACTIVE	101120944015	\N
1011209440157220	Sample description	ACTIVE	101120944015	\N
1011209440156145	Sample description	ACTIVE	101120944015	\N
1011209440156236	Sample description	ACTIVE	101120944015	\N
1011209440156398	Sample description	ACTIVE	101120944015	\N
1011209440156403	Sample description	ACTIVE	101120944015	\N
1011209440156697	Sample description	ACTIVE	101120944015	\N
1011209440157495	Sample description	ACTIVE	101120944015	\N
1011209443586247	Sample description	ACTIVE	101120944358	\N
1011209443586257	Sample description	ACTIVE	101120944358	\N
1011209443586343	Sample description	ACTIVE	101120944358	\N
1011209443586509	Sample description	ACTIVE	101120944358	\N
1011209443586516	Sample description	ACTIVE	101120944358	\N
1011209443527463	Sample description	ACTIVE	101120944352	\N
1011209443526273	Sample description	ACTIVE	101120944352	\N
1011209443526277	Sample description	ACTIVE	101120944352	\N
1011209443526278	Sample description	ACTIVE	101120944352	\N
1011209443526275	Sample description	ACTIVE	101120944352	\N
1011209443526739	Sample description	ACTIVE	101120944352	\N
1011209440386289	Sample description	ACTIVE	101120944038	\N
1011209440386288	Sample description	ACTIVE	101120944038	\N
1011209440386294	Sample description	ACTIVE	101120944038	\N
1011209440386359	Sample description	ACTIVE	101120944038	\N
1011209440386363	Sample description	ACTIVE	101120944038	\N
1011209440386365	Sample description	ACTIVE	101120944038	\N
1011209443516475	Sample description	ACTIVE	101120944351	\N
1011209443516476	Sample description	ACTIVE	101120944351	\N
1011209443516477	Sample description	ACTIVE	101120944351	\N
1011209443516647	Sample description	ACTIVE	101120944351	\N
1011209443516648	Sample description	ACTIVE	101120944351	\N
1011209443516640	Sample description	ACTIVE	101120944351	\N
1011209443516644	Sample description	ACTIVE	101120944351	\N
1011209443516729	Sample description	ACTIVE	101120944351	\N
1011209443516829	Sample description	ACTIVE	101120944351	\N
1011209443516830	Sample description	ACTIVE	101120944351	\N
1011209443516629	Sample description	ACTIVE	101120944351	\N
1011209443516630	Sample description	ACTIVE	101120944351	\N
1011209443516631	Sample description	ACTIVE	101120944351	\N
1011209443516649	Sample description	ACTIVE	101120944351	\N
1011209443516636	Sample description	ACTIVE	101120944351	\N
1011209443516642	Sample description	ACTIVE	101120944351	\N
1011209440756054	Sample description	ACTIVE	101120944075	\N
1011209440756348	Sample description	ACTIVE	101120944075	\N
1011209440756349	Sample description	ACTIVE	101120944075	\N
1011209440756686	Sample description	ACTIVE	101120944075	\N
1011209440756680	Sample description	ACTIVE	101120944075	\N
1011209440756685	Sample description	ACTIVE	101120944075	\N
1011209440757042	Sample description	ACTIVE	101120944075	\N
1011209440757506	Sample description	ACTIVE	101120944075	\N
1011209440976820	Sample description	ACTIVE	101120944097	\N
1011209440976821	Sample description	ACTIVE	101120944097	\N
1011209443907515	Sample description	ACTIVE	101120944390	\N
1011209443897505	Sample description	ACTIVE	101120944389	\N
1011209443887461	Sample description	ACTIVE	101120944388	\N
1011209441297273	Sample description	ACTIVE	101120944129	\N
1011209441297278	Sample description	ACTIVE	101120944129	\N
1011209441446970	Sample description	ACTIVE	101120944144	\N
1011209441447398	Sample description	ACTIVE	101120944144	\N
1011209441447399	Sample description	ACTIVE	101120944144	\N
1011209441447400	Sample description	ACTIVE	101120944144	\N
1011209441447401	Sample description	ACTIVE	101120944144	\N
1011209441447502	Sample description	ACTIVE	101120944144	\N
1011209441447402	Sample description	ACTIVE	101120944144	\N
1011209441447146	Sample description	ACTIVE	101120944144	\N
1011209441447139	Sample description	ACTIVE	101120944144	\N
1011209441447140	Sample description	ACTIVE	101120944144	\N
1011209441447141	Sample description	ACTIVE	101120944144	\N
1011209441447143	Sample description	ACTIVE	101120944144	\N
1011209441447393	Sample description	ACTIVE	101120944144	\N
1011209441446973	Sample description	ACTIVE	101120944144	\N
1011209441447145	Sample description	ACTIVE	101120944144	\N
1011209441447144	Sample description	ACTIVE	101120944144	\N
1011209441447131	Sample description	ACTIVE	101120944144	\N
1011209441447133	Sample description	ACTIVE	101120944144	\N
1011209441447134	Sample description	ACTIVE	101120944144	\N
1011209343436023	Sample description	ACTIVE	101120934343	\N
1011209343437028	Sample description	ACTIVE	101120934343	\N
1011209343437223	Sample description	ACTIVE	101120934343	\N
1011209343437293	Sample description	ACTIVE	101120934343	\N
1011209543546269	Sample description	ACTIVE	101120954354	\N
1011209543546425	Sample description	ACTIVE	101120954354	\N
1011209543546427	Sample description	ACTIVE	101120954354	\N
1011209543546429	Sample description	ACTIVE	101120954354	\N
1011209543546430	Sample description	ACTIVE	101120954354	\N
1011209543556468	Sample description	ACTIVE	101120954355	\N
1011209543556485	Sample description	ACTIVE	101120954355	\N
1011209543576492	Sample description	ACTIVE	101120954357	\N
1011209543576493	Sample description	ACTIVE	101120954357	\N
1011209543576495	Sample description	ACTIVE	101120954357	\N
1011209543576498	Sample description	ACTIVE	101120954357	\N
1011210843667041	Sample description	ACTIVE	101121084366	\N
1011210843676371	Sample description	ACTIVE	101121084367	\N
1011210843656227	Sample description	ACTIVE	101121084365	\N
1011210843657341	Sample description	ACTIVE	101121084365	\N
1011210843657365	Sample description	ACTIVE	101121084365	\N
1011210843746566	Sample description	ACTIVE	101121084374	\N
1011210843727040	Sample description	ACTIVE	101121084372	\N
1011210841216238	Sample description	ACTIVE	101121084121	\N
1011210841216458	Sample description	ACTIVE	101121084121	\N
1011210841216607	Sample description	ACTIVE	101121084121	\N
1011210841216602	Sample description	ACTIVE	101121084121	\N
1011210841216711	Sample description	ACTIVE	101121084121	\N
1011210841217504	Sample description	ACTIVE	101121084121	\N
1011210841217214	Sample description	ACTIVE	101121084121	\N
1011210841217403	Sample description	ACTIVE	101121084121	\N
1011210841217037	Sample description	ACTIVE	101121084121	\N
1011210841217066	Sample description	ACTIVE	101121084121	\N
1011210841217118	Sample description	ACTIVE	101121084121	\N
1011210841217120	Sample description	ACTIVE	101121084121	\N
1011210841217503	Sample description	ACTIVE	101121084121	\N
1011210841217215	Sample description	ACTIVE	101121084121	\N
1011210841217213	Sample description	ACTIVE	101121084121	\N
1011210841216831	Sample description	ACTIVE	101121084121	\N
1011210841216882	Sample description	ACTIVE	101121084121	\N
1011210841217151	Sample description	ACTIVE	101121084121	\N
1011210841216888	Sample description	ACTIVE	101121084121	\N
1011210841216889	Sample description	ACTIVE	101121084121	\N
1011210841217036	Sample description	ACTIVE	101121084121	\N
1011210843737221	Sample description	ACTIVE	101121084373	\N
1011210843737222	Sample description	ACTIVE	101121084373	\N
1011210843737224	Sample description	ACTIVE	101121084373	\N
1011210843737225	Sample description	ACTIVE	101121084373	\N
1011210841457499	Sample description	ACTIVE	101121084145	\N
1011210841456020	Sample description	ACTIVE	101121084145	\N
1011210841456667	Sample description	ACTIVE	101121084145	\N
1011210841456668	Sample description	ACTIVE	101121084145	\N
1011210841457404	Sample description	ACTIVE	101121084145	\N
1011210843697407	Sample description	ACTIVE	101121084369	\N
1011210443476270	Sample description	ACTIVE	101121044347	\N
1011210443596563	Sample description	ACTIVE	101121044359	\N
1011210440816274	Sample description	ACTIVE	101121044081	\N
1011210440817136	Sample description	ACTIVE	101121044081	\N
1011210440826237	Sample description	ACTIVE	101121044082	\N
1011210440826251	Sample description	ACTIVE	101121044082	\N
1011210440826564	Sample description	ACTIVE	101121044082	\N
1011210440826565	Sample description	ACTIVE	101121044082	\N
1011210440826732	Sample description	ACTIVE	101121044082	\N
1011209741026855	Sample description	ACTIVE	101120974102	\N
1011209741027274	Sample description	ACTIVE	101120974102	\N
1011209741026857	Sample description	ACTIVE	101120974102	\N
1011209741027340	Sample description	ACTIVE	101120974102	\N
1011209741027276	Sample description	ACTIVE	101120974102	\N
1011209741026854	Sample description	ACTIVE	101120974102	\N
1011209741026856	Sample description	ACTIVE	101120974102	\N
1011209741026858	Sample description	ACTIVE	101120974102	\N
1011209741027024	Sample description	ACTIVE	101120974102	\N
1011209741027279	Sample description	ACTIVE	101120974102	\N
1011209741027372	Sample description	ACTIVE	101120974102	\N
1011210743646939	Sample description	ACTIVE	101121074364	\N
1011210743766940	Sample description	ACTIVE	101121074376	\N
1011210743766944	Sample description	ACTIVE	101121074376	\N
1011210743766960	Sample description	ACTIVE	101121074376	\N
1011210743766961	Sample description	ACTIVE	101121074376	\N
1011210743766953	Sample description	ACTIVE	101121074376	\N
1011210743766954	Sample description	ACTIVE	101121074376	\N
1011210743766955	Sample description	ACTIVE	101121074376	\N
1011210743766956	Sample description	ACTIVE	101121074376	\N
1011210743766958	Sample description	ACTIVE	101121074376	\N
1011210743766959	Sample description	ACTIVE	101121074376	\N
1011210743766945	Sample description	ACTIVE	101121074376	\N
1011210743766946	Sample description	ACTIVE	101121074376	\N
1011210743766947	Sample description	ACTIVE	101121074376	\N
1011210743766948	Sample description	ACTIVE	101121074376	\N
1011210743766950	Sample description	ACTIVE	101121074376	\N
1011210743766952	Sample description	ACTIVE	101121074376	\N
1011209943706967	Sample description	ACTIVE	101120994370	\N
1011209943706968	Sample description	ACTIVE	101120994370	\N
1011209943706969	Sample description	ACTIVE	101120994370	\N
1011210043716670	Sample description	ACTIVE	101121004371	\N
1011210043716671	Sample description	ACTIVE	101121004371	\N
1008206240026060	Sample description	ACTIVE	100820624002	\N
1008206240027116	Sample description	ACTIVE	100820624002	\N
1008206341546346	Sample description	ACTIVE	100820634154	\N
1008206441536347	Sample description	ACTIVE	100820644153	\N
1008206140446031	Sample description	ACTIVE	100820614044	\N
1008206140446404	Sample description	ACTIVE	100820614044	\N
1008206140446320	Sample description	ACTIVE	100820614044	\N
1008206140446319	Sample description	ACTIVE	100820614044	\N
1008206140446388	Sample description	ACTIVE	100820614044	\N
1008206140447029	Sample description	ACTIVE	100820614044	\N
1008206140446744	Sample description	ACTIVE	100820614044	\N
1008206140446808	Sample description	ACTIVE	100820614044	\N
1008206140447103	Sample description	ACTIVE	100820614044	\N
1008206140447172	Sample description	ACTIVE	100820614044	\N
1008206140447180	Sample description	ACTIVE	100820614044	\N
1008206140447272	Sample description	ACTIVE	100820614044	\N
1008206140447291	Sample description	ACTIVE	100820614044	\N
1008206140446483	Sample description	ACTIVE	100820614044	\N
1008206140446504	Sample description	ACTIVE	100820614044	\N
1008206140446661	Sample description	ACTIVE	100820614044	\N
1008206140446721	Sample description	ACTIVE	100820614044	\N
1008206140446733	Sample description	ACTIVE	100820614044	\N
1008206140446762	Sample description	ACTIVE	100820614044	\N
1008206541097123	Sample description	ACTIVE	100820654109	\N
1008206541097203	Sample description	ACTIVE	100820654109	\N
1008206541097375	Sample description	ACTIVE	100820654109	\N
1008206541096938	Sample description	ACTIVE	100820654109	\N
1008206541096941	Sample description	ACTIVE	100820654109	\N
1008206541096942	Sample description	ACTIVE	100820654109	\N
1008206541096943	Sample description	ACTIVE	100820654109	\N
1008206541097033	Sample description	ACTIVE	100820654109	\N
1008206541097108	Sample description	ACTIVE	100820654109	\N
1008206541096487	Sample description	ACTIVE	100820654109	\N
1008206541096556	Sample description	ACTIVE	100820654109	\N
1008206541096717	Sample description	ACTIVE	100820654109	\N
1008206541096822	Sample description	ACTIVE	100820654109	\N
1008206541096823	Sample description	ACTIVE	100820654109	\N
1008206541096839	Sample description	ACTIVE	100820654109	\N
1008206541096086	Sample description	ACTIVE	100820654109	\N
1008206541096087	Sample description	ACTIVE	100820654109	\N
1008206541096443	Sample description	ACTIVE	100820654109	\N
1008206541096459	Sample description	ACTIVE	100820654109	\N
1008206541096460	Sample description	ACTIVE	100820654109	\N
1008206041136089	Sample description	ACTIVE	100820604113	\N
1008206041136093	Sample description	ACTIVE	100820604113	\N
1008206041137032	Sample description	ACTIVE	100820604113	\N
1010200041646026	Sample description	ACTIVE	101020004164	\N
1010200041676027	Sample description	ACTIVE	101020004167	\N
1010200041676028	Sample description	ACTIVE	101020004167	\N
1010200041676029	Sample description	ACTIVE	101020004167	\N
1010200041676030	Sample description	ACTIVE	101020004167	\N
1010200041676032	Sample description	ACTIVE	101020004167	\N
1010200041676033	Sample description	ACTIVE	101020004167	\N
1010200041676041	Sample description	ACTIVE	101020004167	\N
1010200041676042	Sample description	ACTIVE	101020004167	\N
1010200041676043	Sample description	ACTIVE	101020004167	\N
1010200041676034	Sample description	ACTIVE	101020004167	\N
1010200041676035	Sample description	ACTIVE	101020004167	\N
1010200041676036	Sample description	ACTIVE	101020004167	\N
1010200041676037	Sample description	ACTIVE	101020004167	\N
1010200041676038	Sample description	ACTIVE	101020004167	\N
1010200041676040	Sample description	ACTIVE	101020004167	\N
1010207141686993	Sample description	ACTIVE	101020714168	\N
1010207141696994	Sample description	ACTIVE	101020714169	\N
1010207141696995	Sample description	ACTIVE	101020714169	\N
1010207141697453	Sample description	ACTIVE	101020714169	\N
1010207141696996	Sample description	ACTIVE	101020714169	\N
1010207141696997	Sample description	ACTIVE	101020714169	\N
1010207141697018	Sample description	ACTIVE	101020714169	\N
1010207141697019	Sample description	ACTIVE	101020714169	\N
1010207141697020	Sample description	ACTIVE	101020714169	\N
1010207141697021	Sample description	ACTIVE	101020714169	\N
1010207141697011	Sample description	ACTIVE	101020714169	\N
1010207141697012	Sample description	ACTIVE	101020714169	\N
1010207141697013	Sample description	ACTIVE	101020714169	\N
1010207141697015	Sample description	ACTIVE	101020714169	\N
1010207141697016	Sample description	ACTIVE	101020714169	\N
1010207141697017	Sample description	ACTIVE	101020714169	\N
1010207141697005	Sample description	ACTIVE	101020714169	\N
1010207141697006	Sample description	ACTIVE	101020714169	\N
1010207141697007	Sample description	ACTIVE	101020714169	\N
1010207141697008	Sample description	ACTIVE	101020714169	\N
1010207141697009	Sample description	ACTIVE	101020714169	\N
1010207141697010	Sample description	ACTIVE	101020714169	\N
1010207141696998	Sample description	ACTIVE	101020714169	\N
1010207141696999	Sample description	ACTIVE	101020714169	\N
1010207141697000	Sample description	ACTIVE	101020714169	\N
1010207141697001	Sample description	ACTIVE	101020714169	\N
1010207141697002	Sample description	ACTIVE	101020714169	\N
1010207141697003	Sample description	ACTIVE	101020714169	\N
1001203540895999	Sample description	ACTIVE	100120354089	\N
1001203540896000	Sample description	ACTIVE	100120354089	\N
1001203540905998	Sample description	ACTIVE	100120354090	\N
1001203540906017	Sample description	ACTIVE	100120354090	\N
1001203640916001	Sample description	ACTIVE	100120364091	\N
1001203640916002	Sample description	ACTIVE	100120364091	\N
1001203640916003	Sample description	ACTIVE	100120364091	\N
1001203640916004	Sample description	ACTIVE	100120364091	\N
1001203640916005	Sample description	ACTIVE	100120364091	\N
1001203640916006	Sample description	ACTIVE	100120364091	\N
1001203640916013	Sample description	ACTIVE	100120364091	\N
1001203640916014	Sample description	ACTIVE	100120364091	\N
1001203640916015	Sample description	ACTIVE	100120364091	\N
1001203640916016	Sample description	ACTIVE	100120364091	\N
1001203640916007	Sample description	ACTIVE	100120364091	\N
1001203640916008	Sample description	ACTIVE	100120364091	\N
1001203640916009	Sample description	ACTIVE	100120364091	\N
1001203640916010	Sample description	ACTIVE	100120364091	\N
1001203640916011	Sample description	ACTIVE	100120364091	\N
1001203640916012	Sample description	ACTIVE	100120364091	\N
1001203640926018	Sample description	ACTIVE	100120364092	\N
1001203640926019	Sample description	ACTIVE	100120364092	\N
1009205041246090	Sample description	ACTIVE	100920504124	\N
1009205041246304	Sample description	ACTIVE	100920504124	\N
1009205041246435	Sample description	ACTIVE	100920504124	\N
1009205041246436	Sample description	ACTIVE	100920504124	\N
1009205041246465	Sample description	ACTIVE	100920504124	\N
1009205041246654	Sample description	ACTIVE	100920504124	\N
1009205041247336	Sample description	ACTIVE	100920504124	\N
1009205041247363	Sample description	ACTIVE	100920504124	\N
1009205041246827	Sample description	ACTIVE	100920504124	\N
1009205041246859	Sample description	ACTIVE	100920504124	\N
1009205041247038	Sample description	ACTIVE	100920504124	\N
1009205041247181	Sample description	ACTIVE	100920504124	\N
1009205041247205	Sample description	ACTIVE	100920504124	\N
1009205041247334	Sample description	ACTIVE	100920504124	\N
\.


--
-- Data for Name: family; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY family (code, description, status) FROM stdin;
﻿1006	Sample description	ACTIVE
1000	Sample description	ACTIVE
1003	Sample description	ACTIVE
1004	Sample description	ACTIVE
1007	Sample description	ACTIVE
1005	Sample description	ACTIVE
1002	Sample description	ACTIVE
1011	Sample description	ACTIVE
1008	Sample description	ACTIVE
1010	Sample description	ACTIVE
1001	Sample description	ACTIVE
1009	Sample description	ACTIVE
\.


--
-- Data for Name: state; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY state (code, name, status) FROM stdin;
﻿AL	ALABAMA	ACTIVE
AK	ALASKA	ACTIVE
AZ	ARIZONA	ACTIVE
AR	ARKANSAS	ACTIVE
CA	CALIFORNIA	ACTIVE
CO	COLORADO	ACTIVE
CT	CONNECTICUT	ACTIVE
DE	DELAWARE	ACTIVE
DC	DISTRICT OF COLUMBIA	ACTIVE
FL	FLORIDA	ACTIVE
GA	GEORGIA	ACTIVE
HI	HAWAII	ACTIVE
ID	IDAHO	ACTIVE
IL	ILLINOIS	ACTIVE
IN	INDIANA	ACTIVE
IA	IOWA	ACTIVE
KS	KANSAS	ACTIVE
KY	KENTUCKY	ACTIVE
LA	LOUISIANA	ACTIVE
ME	MAINE	ACTIVE
MD	MARYLAND	ACTIVE
MA	MASSACHUSETTS	ACTIVE
MI	MICHIGAN	ACTIVE
MN	MINNESOTA	ACTIVE
MS	MISSISSIPPI	ACTIVE
MO	MISSOURI	ACTIVE
MT	MONTANA	ACTIVE
NE	NEBRASKA	ACTIVE
NV	NEVADA	ACTIVE
NH	NEW HAMPSHIRE	ACTIVE
NJ	NEW JERSEY	ACTIVE
NM	NEW MEXICO	ACTIVE
NY	NEW YORK	ACTIVE
NC	NORTH CAROLINA	ACTIVE
ND	NORTH DAKOTA	ACTIVE
OH	OHIO	ACTIVE
OK	OKLAHOMA	ACTIVE
OR	OREGON	ACTIVE
PA	PENNSYLVANIA	ACTIVE
PR	PUERTO RICO	ACTIVE
RI	RHODE ISLAND	ACTIVE
SC	SOUTH CAROLINA	ACTIVE
SD	SOUTH DAKOTA	ACTIVE
TN	TENNESSEE	ACTIVE
TX	TEXAS	ACTIVE
UT	UTAH	ACTIVE
VT	VERMONT	ACTIVE
VA	VIRGINIA	ACTIVE
WA	WASHINGTON	ACTIVE
WV	WEST VIRGINIA	ACTIVE
WI	WISCONSIN	ACTIVE
WY	WYOMING	ACTIVE
AL	AL	ACTIVE
AB	AB	ACTIVE
VI	VI	ACTIVE
BW	BW	ACTIVE
BC	BC	ACTIVE
PD	PD	ACTIVE
ON	ON	ACTIVE
TO	TO	ACTIVE
LC	LC	ACTIVE
QB	QB	ACTIVE
QC	QC	ACTIVE
TC	TC	ACTIVE
DF	DF	ACTIVE
BG	BG	ACTIVE
TV	TV	ACTIVE
PV	PV	ACTIVE
NO	NO	ACTIVE
BO	BO	ACTIVE
LI	LI	ACTIVE
PQ	PQ	ACTIVE
CR	CR	ACTIVE
SP	SP	ACTIVE
BS	BS	ACTIVE
PO	PO	ACTIVE
MB	MB	ACTIVE
TA	TA	ACTIVE
VR	VR	ACTIVE
PC	PC	ACTIVE
PZ	PZ	ACTIVE
QU	QU	ACTIVE
BV	BV	ACTIVE
CH	CH	ACTIVE
RE	RE	ACTIVE
SV	SV	ACTIVE
AG	AG	ACTIVE
PI	PI	ACTIVE
NB	NB	ACTIVE
BM	BM	ACTIVE
GR	GR	ACTIVE
VC	VC	ACTIVE
NL	NL	ACTIVE
\.


--
-- Data for Name: sub_category; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY sub_category (code, description, status, category_code, idx) FROM stdin;
﻿100620024005	Sample description	ACTIVE	\N	\N
100620024047	Sample description	ACTIVE	\N	\N
100620034173	Sample description	ACTIVE	10062003	\N
100620034178	Sample description	ACTIVE	10062003	\N
100620034176	Sample description	ACTIVE	10062003	\N
100620034181	Sample description	ACTIVE	10062003	\N
100620034182	Sample description	ACTIVE	10062003	\N
100620034184	Sample description	ACTIVE	10062003	\N
100620034180	Sample description	ACTIVE	10062003	\N
100620034174	Sample description	ACTIVE	10062003	\N
100620034175	Sample description	ACTIVE	10062003	\N
100620034179	Sample description	ACTIVE	10062003	\N
100620034183	Sample description	ACTIVE	10062003	\N
100620034177	Sample description	ACTIVE	10062003	\N
100620034185	Sample description	ACTIVE	10062003	\N
100620754189	Sample description	ACTIVE	10062075	\N
100620754187	Sample description	ACTIVE	10062075	\N
100620754191	Sample description	ACTIVE	10062075	\N
100620754188	Sample description	ACTIVE	10062075	\N
100620754192	Sample description	ACTIVE	10062075	\N
100620754190	Sample description	ACTIVE	10062075	\N
100620064193	Sample description	ACTIVE	10062006	\N
100620064197	Sample description	ACTIVE	10062006	\N
100620064202	Sample description	ACTIVE	10062006	\N
100620064196	Sample description	ACTIVE	10062006	\N
100620064201	Sample description	ACTIVE	10062006	\N
100620064200	Sample description	ACTIVE	10062006	\N
100620074203	Sample description	ACTIVE	10062007	\N
100620074204	Sample description	ACTIVE	10062007	\N
100620074205	Sample description	ACTIVE	10062007	\N
100620074207	Sample description	ACTIVE	10062007	\N
100620074208	Sample description	ACTIVE	10062007	\N
100620074210	Sample description	ACTIVE	10062007	\N
100620074211	Sample description	ACTIVE	10062007	\N
100620074212	Sample description	ACTIVE	10062007	\N
100620074206	Sample description	ACTIVE	10062007	\N
100620094215	Sample description	ACTIVE	10062009	\N
100620094213	Sample description	ACTIVE	10062009	\N
100620094218	Sample description	ACTIVE	10062009	\N
100620094024	Sample description	ACTIVE	10062009	\N
100620094093	Sample description	ACTIVE	10062009	\N
100620094217	Sample description	ACTIVE	10062009	\N
100620094214	Sample description	ACTIVE	10062009	\N
100621134220	Sample description	ACTIVE	10062113	\N
100621134221	Sample description	ACTIVE	10062113	\N
100621134219	Sample description	ACTIVE	10062113	\N
100621134222	Sample description	ACTIVE	10062113	\N
100620174227	Sample description	ACTIVE	10062017	\N
100620174226	Sample description	ACTIVE	10062017	\N
100620174231	Sample description	ACTIVE	10062017	\N
100620174230	Sample description	ACTIVE	10062017	\N
100620174228	Sample description	ACTIVE	10062017	\N
100620174232	Sample description	ACTIVE	10062017	\N
100620184055	Sample description	ACTIVE	10062018	\N
100620184053	Sample description	ACTIVE	10062018	\N
100620774067	Sample description	ACTIVE	10062077	\N
100620784237	Sample description	ACTIVE	10062078	\N
100620784240	Sample description	ACTIVE	10062078	\N
100620784238	Sample description	ACTIVE	10062078	\N
100620784239	Sample description	ACTIVE	10062078	\N
100620244242	Sample description	ACTIVE	10062024	\N
100620244241	Sample description	ACTIVE	10062024	\N
100620244243	Sample description	ACTIVE	10062024	\N
100620274248	Sample description	ACTIVE	10062027	\N
100620274249	Sample description	ACTIVE	10062027	\N
100620274246	Sample description	ACTIVE	10062027	\N
100620274250	Sample description	ACTIVE	10062027	\N
100620274244	Sample description	ACTIVE	10062027	\N
100620274252	Sample description	ACTIVE	10062027	\N
100620274253	Sample description	ACTIVE	10062027	\N
100620274062	Sample description	ACTIVE	10062027	\N
100620274254	Sample description	ACTIVE	10062027	\N
100620274245	Sample description	ACTIVE	10062027	\N
100620274251	Sample description	ACTIVE	10062027	\N
100620794258	Sample description	ACTIVE	10062079	\N
100620794260	Sample description	ACTIVE	10062079	\N
100620794262	Sample description	ACTIVE	10062079	\N
100620794259	Sample description	ACTIVE	10062079	\N
100620794261	Sample description	ACTIVE	10062079	\N
100620424387	Sample description	ACTIVE	10062042	\N
100620424263	Sample description	ACTIVE	10062042	\N
100620424266	Sample description	ACTIVE	10062042	\N
100620424265	Sample description	ACTIVE	10062042	\N
100620424264	Sample description	ACTIVE	10062042	\N
100620424267	Sample description	ACTIVE	10062042	\N
100620434270	Sample description	ACTIVE	10062043	\N
100620434115	Sample description	ACTIVE	10062043	\N
100620434268	Sample description	ACTIVE	10062043	\N
100620434269	Sample description	ACTIVE	10062043	\N
100620444271	Sample description	ACTIVE	10062044	\N
100620444272	Sample description	ACTIVE	10062044	\N
100620444386	Sample description	ACTIVE	10062044	\N
100620444276	Sample description	ACTIVE	10062044	\N
100620444274	Sample description	ACTIVE	10062044	\N
100620744380	Sample description	ACTIVE	10062074	\N
100620744225	Sample description	ACTIVE	10062074	\N
100620744186	Sample description	ACTIVE	10062074	\N
100620744223	Sample description	ACTIVE	10062074	\N
100620804277	Sample description	ACTIVE	10062080	\N
100620804279	Sample description	ACTIVE	10062080	\N
100620804377	Sample description	ACTIVE	10062080	\N
100620804280	Sample description	ACTIVE	10062080	\N
100620804281	Sample description	ACTIVE	10062080	\N
100620804143	Sample description	ACTIVE	10062080	\N
100620764234	Sample description	ACTIVE	10062076	\N
100620764235	Sample description	ACTIVE	10062076	\N
100620764236	Sample description	ACTIVE	10062076	\N
100620764233	Sample description	ACTIVE	10062076	\N
100620814282	Sample description	ACTIVE	10062081	\N
100620814284	Sample description	ACTIVE	10062081	\N
100620814283	Sample description	ACTIVE	10062081	\N
100620814378	Sample description	ACTIVE	10062081	\N
100620824287	Sample description	ACTIVE	10062082	\N
100620824285	Sample description	ACTIVE	10062082	\N
100620824286	Sample description	ACTIVE	10062082	\N
100620584032	Sample description	ACTIVE	10062058	\N
100620584031	Sample description	ACTIVE	10062058	\N
100620584029	Sample description	ACTIVE	10062058	\N
100620584139	Sample description	ACTIVE	10062058	\N
100620584138	Sample description	ACTIVE	10062058	\N
100620584136	Sample description	ACTIVE	10062058	\N
100020834288	Sample description	ACTIVE	10002083	\N
100020834003	Sample description	ACTIVE	10002083	\N
100020834066	Sample description	ACTIVE	10002083	\N
100020834095	Sample description	ACTIVE	10002083	\N
100020834290	Sample description	ACTIVE	10002083	\N
100020834289	Sample description	ACTIVE	10002083	\N
100020834114	Sample description	ACTIVE	10002083	\N
100021124006	Sample description	ACTIVE	10002112	\N
100021124084	Sample description	ACTIVE	10002112	\N
100020864291	Sample description	ACTIVE	10002086	\N
100020864292	Sample description	ACTIVE	10002086	\N
100020864293	Sample description	ACTIVE	10002086	\N
100020864295	Sample description	ACTIVE	10002086	\N
100020864294	Sample description	ACTIVE	10002086	\N
100020854008	Sample description	ACTIVE	10002085	\N
100020054022	Sample description	ACTIVE	10002005	\N
100020054037	Sample description	ACTIVE	10002005	\N
100020874296	Sample description	ACTIVE	10002087	\N
100020874298	Sample description	ACTIVE	10002087	\N
100020874300	Sample description	ACTIVE	10002087	\N
100020874385	Sample description	ACTIVE	10002087	\N
100020874297	Sample description	ACTIVE	10002087	\N
100020874299	Sample description	ACTIVE	10002087	\N
100020874384	Sample description	ACTIVE	10002087	\N
100020884302	Sample description	ACTIVE	10002088	\N
100020884382	Sample description	ACTIVE	10002088	\N
100020884304	Sample description	ACTIVE	10002088	\N
100020884307	Sample description	ACTIVE	10002088	\N
100020884308	Sample description	ACTIVE	10002088	\N
100020884303	Sample description	ACTIVE	10002088	\N
100020884305	Sample description	ACTIVE	10002088	\N
100020884306	Sample description	ACTIVE	10002088	\N
100020884379	Sample description	ACTIVE	10002088	\N
100020884125	Sample description	ACTIVE	10002088	\N
100021114048	Sample description	ACTIVE	10002111	\N
100020894078	Sample description	ACTIVE	10002089	\N
100020894133	Sample description	ACTIVE	10002089	\N
100020914315	Sample description	ACTIVE	10002091	\N
100020914322	Sample description	ACTIVE	10002091	\N
100020914319	Sample description	ACTIVE	10002091	\N
100020914320	Sample description	ACTIVE	10002091	\N
100020914321	Sample description	ACTIVE	10002091	\N
100020914323	Sample description	ACTIVE	10002091	\N
100020914318	Sample description	ACTIVE	10002091	\N
100020914316	Sample description	ACTIVE	10002091	\N
100020914107	Sample description	ACTIVE	10002091	\N
100020324085	Sample description	ACTIVE	10002032	\N
100020404328	Sample description	ACTIVE	10002040	\N
100020404329	Sample description	ACTIVE	10002040	\N
100020404330	Sample description	ACTIVE	10002040	\N
100020404325	Sample description	ACTIVE	10002040	\N
100020404326	Sample description	ACTIVE	10002040	\N
100020404327	Sample description	ACTIVE	10002040	\N
100020404324	Sample description	ACTIVE	10002040	\N
100020404334	Sample description	ACTIVE	10002040	\N
100020404332	Sample description	ACTIVE	10002040	\N
100020404331	Sample description	ACTIVE	10002040	\N
100020404333	Sample description	ACTIVE	10002040	\N
100020904309	Sample description	ACTIVE	10002090	\N
100020904311	Sample description	ACTIVE	10002090	\N
100020904314	Sample description	ACTIVE	10002090	\N
100020904312	Sample description	ACTIVE	10002090	\N
100020454335	Sample description	ACTIVE	10002045	\N
100020454341	Sample description	ACTIVE	10002045	\N
100020454336	Sample description	ACTIVE	10002045	\N
100020454337	Sample description	ACTIVE	10002045	\N
100020454339	Sample description	ACTIVE	10002045	\N
100020454338	Sample description	ACTIVE	10002045	\N
100020454340	Sample description	ACTIVE	10002045	\N
100020734170	Sample description	ACTIVE	10002073	\N
100020734141	Sample description	ACTIVE	10002073	\N
100020734142	Sample description	ACTIVE	10002073	\N
100020734140	Sample description	ACTIVE	10002073	\N
100020734171	Sample description	ACTIVE	10002073	\N
100320284077	Sample description	ACTIVE	10032028	\N
100320484122	Sample description	ACTIVE	10032048	\N
100320194063	Sample description	ACTIVE	10032019	\N
100320494123	Sample description	ACTIVE	10032049	\N
100320554134	Sample description	ACTIVE	10032055	\N
100320414104	Sample description	ACTIVE	10032041	\N
100320234070	Sample description	ACTIVE	10032023	\N
100320524127	Sample description	ACTIVE	10032052	\N
100320524065	Sample description	ACTIVE	10032052	\N
100320524128	Sample description	ACTIVE	10032052	\N
100320524064	Sample description	ACTIVE	10032052	\N
100320334086	Sample description	ACTIVE	10032033	\N
100420264074	Sample description	ACTIVE	10042026	\N
100420254073	Sample description	ACTIVE	10042025	\N
100420394100	Sample description	ACTIVE	10042039	\N
100720474120	Sample description	ACTIVE	10072047	\N
100720464119	Sample description	ACTIVE	10072046	\N
100520134159	Sample description	ACTIVE	10052013	\N
100520144049	Sample description	ACTIVE	10052014	\N
100520344160	Sample description	ACTIVE	10052034	\N
100520664381	Sample description	ACTIVE	10052066	\N
100520664163	Sample description	ACTIVE	10052066	\N
100520664161	Sample description	ACTIVE	10052066	\N
100520664162	Sample description	ACTIVE	10052066	\N
100220594146	Sample description	ACTIVE	10022059	\N
100220594149	Sample description	ACTIVE	10022059	\N
100220594148	Sample description	ACTIVE	10022059	\N
100220594150	Sample description	ACTIVE	10022059	\N
100220594151	Sample description	ACTIVE	10022059	\N
100220594152	Sample description	ACTIVE	10022059	\N
101121014350	Sample description	ACTIVE	10112101	\N
101120924342	Sample description	ACTIVE	10112092	\N
101120944349	Sample description	ACTIVE	10112094	\N
101120944015	Sample description	ACTIVE	10112094	\N
101120944358	Sample description	ACTIVE	10112094	\N
101120944352	Sample description	ACTIVE	10112094	\N
101120944038	Sample description	ACTIVE	10112094	\N
101120944351	Sample description	ACTIVE	10112094	\N
101120944075	Sample description	ACTIVE	10112094	\N
101120944097	Sample description	ACTIVE	10112094	\N
101120944390	Sample description	ACTIVE	10112094	\N
101120944389	Sample description	ACTIVE	10112094	\N
101120944388	Sample description	ACTIVE	10112094	\N
101120944129	Sample description	ACTIVE	10112094	\N
101120944144	Sample description	ACTIVE	10112094	\N
101120934343	Sample description	ACTIVE	10112093	\N
101120954354	Sample description	ACTIVE	10112095	\N
101120954355	Sample description	ACTIVE	10112095	\N
101120954357	Sample description	ACTIVE	10112095	\N
101121084366	Sample description	ACTIVE	10112108	\N
101121084367	Sample description	ACTIVE	10112108	\N
101121084365	Sample description	ACTIVE	10112108	\N
101121084374	Sample description	ACTIVE	10112108	\N
101121084372	Sample description	ACTIVE	10112108	\N
101121084121	Sample description	ACTIVE	10112108	\N
101121084373	Sample description	ACTIVE	10112108	\N
101121084145	Sample description	ACTIVE	10112108	\N
101121084369	Sample description	ACTIVE	10112108	\N
101121044347	Sample description	ACTIVE	10112104	\N
101121044359	Sample description	ACTIVE	10112104	\N
101121044081	Sample description	ACTIVE	10112104	\N
101121044082	Sample description	ACTIVE	10112104	\N
101120974102	Sample description	ACTIVE	10112097	\N
101121074364	Sample description	ACTIVE	10112107	\N
101121074376	Sample description	ACTIVE	10112107	\N
101120994370	Sample description	ACTIVE	10112099	\N
101121004371	Sample description	ACTIVE	10112100	\N
100820624002	Sample description	ACTIVE	10082062	\N
100820634154	Sample description	ACTIVE	10082063	\N
100820644153	Sample description	ACTIVE	10082064	\N
100820614044	Sample description	ACTIVE	10082061	\N
100820654109	Sample description	ACTIVE	10082065	\N
100820604113	Sample description	ACTIVE	10082060	\N
101020004164	Sample description	ACTIVE	10102000	\N
101020004167	Sample description	ACTIVE	10102000	\N
101020714168	Sample description	ACTIVE	10102071	\N
101020714169	Sample description	ACTIVE	10102071	\N
100120354089	Sample description	ACTIVE	10012035	\N
100120354090	Sample description	ACTIVE	10012035	\N
100120364091	Sample description	ACTIVE	10012036	\N
100120364092	Sample description	ACTIVE	10012036	\N
100920504124	Sample description	ACTIVE	10092050	\N
\.


--
-- Name: area_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY area
    ADD CONSTRAINT area_pkey PRIMARY KEY (code);


--
-- Name: category_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY category
    ADD CONSTRAINT category_pkey PRIMARY KEY (code);


--
-- Name: department_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY department
    ADD CONSTRAINT department_pkey PRIMARY KEY (code);


--
-- Name: family_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY family
    ADD CONSTRAINT family_pkey PRIMARY KEY (code);


--
-- Name: state_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY state
    ADD CONSTRAINT state_pkey PRIMARY KEY (code);


--
-- Name: sub_category_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY sub_category
    ADD CONSTRAINT sub_category_pkey PRIMARY KEY (code);


--
-- Name: fk2085003da06f61ff; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY sub_category
    ADD CONSTRAINT fk2085003da06f61ff FOREIGN KEY (category_code) REFERENCES category(code);


--
-- Name: fk31a8acfe51ef27f; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY category
    ADD CONSTRAINT fk31a8acfe51ef27f FOREIGN KEY (family_code) REFERENCES family(code);


--
-- Name: fk4f782f5293c492da; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY department
    ADD CONSTRAINT fk4f782f5293c492da FOREIGN KEY (sub_category_code) REFERENCES sub_category(code);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

