package at.or.mips.db0.sql.postgres;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import at.or.mips.db0.sql.SqlProvider;

public class PostgresProvider extends SqlProvider {

	public static final String POSTGRES_DRIVER = "org.postgresql.Driver";  
	public static final String POSTGRES_PREFIX = "jdbc:postgresql://";
	
	@Override
	public void  initConnection(String server, String db, String user,
			String pwd) throws SQLException, ClassNotFoundException 
	{
		Class.forName(POSTGRES_DRIVER); 
		setConnection(DriverManager.getConnection(POSTGRES_PREFIX + server + "/" + db,user,pwd));
	}

	@Override
	public PreparedStatement prepareStatement(String sql) throws SQLException 
	{return getConnection().prepareStatement(sql,ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);	}
	
	@Override
	public void execute(String sql) throws SQLException 
	{
		Statement stmt = getConnection().createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
				ResultSet.CONCUR_UPDATABLE);
		stmt.execute(sql);
	}

	@Override
	public ResultSet query(String sql) throws SQLException 
	{
		Statement stmt = getConnection().createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
				ResultSet.CONCUR_UPDATABLE);
		return stmt.executeQuery(sql);
	}

	@Override
	public int update(String sql) throws SQLException 
	{
		Statement stmt = getConnection().createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
				ResultSet.CONCUR_UPDATABLE);
		
		return stmt.executeUpdate(sql);
	}

}
