package at.or.mips.db0.orm;  

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;

/**
 * @author Robert Wimmer
 */
public class TypeMapper {

	/**
	 * Maps a java field to an sql type. If no matching type is found the type OTHER will be returned 
	 * @param f the java object field that should be mapped 	
	 * @return the corresponding sql type
	 */
	public static int mapToSqlType(Field f)
	{
		int ret = Types.OTHER; 
		// primitive types and wrappers
		if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class ) ret = Types.BOOLEAN;
		else if (f.getType() == Integer.TYPE || f.getType() == Integer.class ) ret = Types.INTEGER;
		else if (f.getType() == Short.TYPE || f.getType() == Short.class ) ret = Types.SMALLINT; 
		else if (f.getType() == Long.TYPE || f.getType() == Long.class ) ret = Types.BIGINT;
		else if (f.getType() == Float.TYPE || f.getType() == Float.class ) ret = Types.REAL; 
		else if (f.getType() == Double.TYPE || f.getType() == Double.class ) ret = Types.DOUBLE; 
		// object types
		else if (f.getType() == BigDecimal.class ) ret = Types.DECIMAL;
		else if (f.getType() == String.class ) ret = Types.VARCHAR; 
		else if (f.getType() == Date.class ) ret = Types.DATE; 
		else if (f.getType() == Time.class ) ret = Types.TIME; 
		else if (f.getType() == Timestamp.class ) ret = Types.TIMESTAMP; 
		
		return ret; 
	}
	
}
