package at.or.mips.db0.orm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ColumnWrapper {
	
	private String sqlName,fieldName;
	private Field field; 
	private boolean updatable,insertable,nullable; 
	private int sqlType; 
	
	public ColumnWrapper(String name)
	{
		this.fieldName = name; 
		this.sqlName = this.fieldName;
		this.updatable = true; 
		this.insertable = true; 
		this.nullable = true; 
	}
	
	/**
	 * returns the database side name of the column
	 * @return the database side name of the column
	 */
	public String getSqlName() {return sqlName;}
	/**
	 * returns if this column should be updated in an UPDATE operation
	 */
	public boolean isUpdatable() {return updatable;}
	/**
	 * returns if this column should be inserted in an INSERT operation
	 */
	public boolean isInsertable() {	return insertable;	}
	/**
	 * returns if this column can be set to NULL
	 */
	public boolean isNullable() {return nullable;}

	/**
	 * returns the sql type this field will be mapped to
	 */
	public int getSqlType() {	return sqlType;}
	/**
	 * returns the field name of the corresponding java object field
	 */
	public String getFieldName() {	return fieldName;	}
	/**
	 * returns the field of the corresponding java object field
	 */
	public Field getField() {	return field;	}

	public void setFieldName(String fieldName) {this.fieldName = fieldName;	}
	public void setField(Field field) {this.field = field;	}
	public void setSqlType(int sqlType) {	this.sqlType = sqlType;}
	public void setSqlName(String name) {this.sqlName = name;	}
	public void setUpdateable(boolean updatable) {	this.updatable = updatable;	}
	public void setInsertable(boolean insertable) {	this.insertable = insertable;	}
	public void setNullable(boolean nullable) {	this.nullable = nullable;	}
	
	public String toString()
	{
		return this.fieldName + ":" + this.field.getType().getSimpleName() + " > " +
			this.sqlName + ":" + this.sqlType + " access:" + this.field.isAccessible(); 
	}
	
}
