package at.or.mips.db0.demo;

import java.sql.SQLException;

import at.or.mips.db0.orm.ModelProxy;
import at.or.mips.db0.sql.postgres.PostgresProvider;

public class Demo {


	public static void main(String[] args) 
	{
		PostgresProvider db = new PostgresProvider(); 
		try { 
			db.initConnection("81.223.126.12","person", "person_guest","guest"); 
			ModelProxy <Person> proxy = new ModelProxy <Person>(Person.class,db);
			proxy.dump(); 
			Person person = new Person(); 
			// should be found
			if (proxy.get(person,new Long(1))) System.out.println("found : " + person.toString()); 
			else System.out.println("not found : " + person.toString()); 
			// should not be found
			if (proxy.get(person,new Long(45678))) System.out.println("found : " + person.toString()); 
			else System.out.println("not found : " + person.toString()); 
			// update
			person.setFirstName("Homero");
			if (proxy.update(person)) System.out.println("updated : " + person.toString()); 
			else System.out.println("not updated : " + person.toString());
			// insert a new one
			Person person2 = new Person(); 
			person2.setFirstName("Ropert");
			person2.setLastName("Wimmer"); 
			person2.setReadOnly(false); 
			person2.setBirthDay(null);
			if (proxy.insert(person2)) System.out.println("inserted : " + person2.toString()); 
			else System.out.println("inserted : " + person2.toString()); 
			}

		catch (SQLException sex) { 
			System.out.println("SQLError : " + sex.getMessage()); 

			sex.printStackTrace(); 
			while (sex.getNextException() != null) sex.getNextException().printStackTrace(); 
			}
		catch (Exception ex) { 	ex.printStackTrace(); }
		System.out.println("done"); 
	}

}
