package at.or.mips.db0.sql; 

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class SqlProvider {

	Connection conn; 
	
	public abstract void initConnection(String server, String db, String user, String pwd) throws SQLException,
		ClassNotFoundException; 
	
	protected void setConnection(Connection conn) { this.conn = conn; } 
	
	public abstract ResultSet query(String sql) throws SQLException; 
	public abstract int update(String sql) throws SQLException;
	public abstract void execute(String sql) throws SQLException; 
	public abstract PreparedStatement prepareStatement(String sql) throws SQLException; 
	
	public Connection getConnection() { return conn; }
	
	public static String coalesce(Object src,String dest) 
	{ if (src == null) return dest; return src.toString(); }
	
	public static String coalesce(Object src) { return coalesce(src,"");  }
	public static String trimToNull(String src)
	{
		if (src == null || src.trim().length() == 0) return null; 
		else return src.trim(); 
	}
	
}


