package at.or.mips.db0.orm; 

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

public class TableWrapper {

	private HashMap <String,ColumnWrapper> columns = new HashMap<String,ColumnWrapper> (); 
	private ColumnWrapper primaryKey; 
	private Class guard; 
	private String entityName,schemaName,tableName; 
	
	public String getQualifiedTableName()
	{
		if (schemaName != null) return schemaName + "." + tableName;  
		else return tableName; 
	}
	
	public TableWrapper(Class guard) throws IntrospectionException
	{ this.guard = guard; this.init();  }
	
	public ColumnWrapper analyzeField(Field field) throws IntrospectionException
	{
		field.setAccessible(true);
		ColumnWrapper wrapper = new ColumnWrapper(field.getName());
		wrapper.setField(field); 
		wrapper.setSqlType(TypeMapper.mapToSqlType(field));
		if (field.isAnnotationPresent(Column.class)) {
			Column anno = field.getAnnotation(Column.class);
			wrapper.setUpdateable(anno.updatable());
			wrapper.setNullable(anno.nullable());
			wrapper.setInsertable(anno.insertable()); 
			
			System.out.println ("("+anno.name()+")");
			if (anno.name() != null && !anno.name().isEmpty()) wrapper.setSqlName(anno.name()); 
			
			}
		if (field.isAnnotationPresent(Id.class)) { 
			if (primaryKey != null ) 
				throw new IntrospectionException("PrimaryKey (" + wrapper.getFieldName() +") already declared" ); 
			
			this.primaryKey = wrapper; 
			}
		return wrapper; 
	}
	
	private void updateColumn(ColumnWrapper wrapper,PropertyDescriptor property)
	{
		//wrapper.setGetter(property.getReadMethod()); 
		//wrapper.setSetter(property.getWriteMethod()); 		
	}
	
	private void init() throws IntrospectionException
	{
		int i; PropertyDescriptor property; 
		BeanInfo info = Introspector.getBeanInfo(guard);

		this.tableName = info.getBeanDescriptor().getName(); 
		this.entityName = info.getBeanDescriptor().getName(); 
		
		if (guard.isAnnotationPresent(Entity.class)) { 
			Entity anno = (Entity)guard.getAnnotation(Entity.class);
			if (anno.name() != null) this.entityName = anno.name();  
			}
		else throw new IllegalArgumentException("class '" + guard.getName() + "' is not marked as @Entity" );
		
		if (guard.isAnnotationPresent(Table.class)) { 
			Table anno = (Table)guard.getAnnotation(Table.class);
			if (anno.name() != null && !anno.name().isEmpty()) this.tableName = anno.name(); 
			if (anno.schema() != null && !anno.schema().isEmpty()) this.schemaName = anno.schema(); 
			}
		
		Field [] fields = guard.getDeclaredFields();
		// create columnWrapper vis FieldReflection
		for (i = 0; i < fields.length; i++) columns.put(fields[i].getName(), this.analyzeField(fields[i]));
		// update columnWrapper using bean getters and setters
		for (i = 0; i < info.getPropertyDescriptors().length; i++) {
			property = info.getPropertyDescriptors()[i]; 
			ColumnWrapper wrapper = columns.get(property.getName()); 
			if (wrapper != null) updateColumn(wrapper,property); 
			}
		if (primaryKey == null) throw new IntrospectionException("no primarykey defined for entity '" + this.entityName + "'");  	
		
	}

	public void dump()
	{	
		System.out.println("Entity <" + this.entityName + "> wraps <" + this.getQualifiedTableName() + ">\n"); 
		for (ColumnWrapper wrapper : columns.values())	System.out.println(wrapper.toString()); 
	}
	
	public Collection <ColumnWrapper> getColumns() {	return columns.values(); }
	public Class getGuard() {	return guard;}
	public String getSchemaName() {return schemaName;}
	public String getTableName() {return tableName;}
	public ColumnWrapper getPrimaryKey() {return primaryKey;	}
	public String getEntityName() {return entityName;	}

	public void setPrimaryKey(ColumnWrapper primaryKey) {this.primaryKey = primaryKey;}
	public void setEntityName(String entityName) {this.entityName = entityName;}
	public void setColumns(HashMap<String, ColumnWrapper> columns) {	this.columns = columns;}
	//public void setGuard(Class guard) {	this.guard = guard;	}
	public void setSchemaName(String schemaName) {this.schemaName = schemaName;}
	public void setTableName(String tableName) {	this.tableName = tableName;}

}
