////////////////////////////////////////////////////////////////////////////
// Name:        rfc2231.cpp
// Purpose:     This class implements the rfc2231 norm
// Author:      Brice Andr
// Created:     2010/12/12
// RCS-ID:      $Id: mycomp.cpp 505 2007-03-31 10:31:46Z frm $
// Copyright:   (c) 2010 Brice Andr
// Licence:     wxWidgets licence
/////////////////////////////////////////////////////////////////////////////


// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// includes
#ifndef WX_PRECOMP
   // here goes the #include <wx/abc.h> directives for those
   // files which are not included by wxprec.h
#endif

#include "wx/encconv.h"
#include "wx/fontmap.h"

#include <wx/codec/charsetconv.h>

wxString wxCharsetConverter::ConvertCharset(const wxString& str, const wxString& char_set)
{
   wxString str_content;
   wxFontEncoding text_encoding = wxFontMapper::Get()->CharsetToEncoding(char_set);
   wxFontEncoding system_encoding = wxLocale::GetSystemEncoding();
   if (text_encoding == wxFONTENCODING_UTF8)
   {
      str_content = wxString::FromUTF8((const char*)str.mb_str(wxConvLocal));
      if (str_content.mb_str(wxConvLocal) == NULL)
      {
         /* Proble during conversion... What can we do ??? */
         str_content = str;
      }
   }
   else if (system_encoding != text_encoding)
   {
      wxEncodingConverter converter;
      bool can_convert = converter.Init(text_encoding, system_encoding);
      if (can_convert)
      {
         str_content = converter.Convert(str);
      }
      else
      {
         /* What can we do ?? */
      }
   }

   return str_content;
}
