# coding: utf-8

import argparse
import psycopg2
import sys
import time
import random


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '--pg',
        dest='pg',
        type=str,
        help="Postgres connection string.",
        default='',
    )
    parser.add_argument(
        '--subxacts',
        dest='subxacts',
        type=int,
        help="Number of subtransactions. Default: %(default)s",
        default=0,
    )
    parser.add_argument(
        '--sleep',
        dest='sleep',
        type=int,
        help="Transaction idle time, in seconds. Default: %(default)s",
        default=100,
    )


    env = parser.parse_args()

    try:
        conn = psycopg2.connect(env.pg)
        conn.set_session(autocommit=False)
    except psycopg2.Error as e:
        sys.exit("Unable to connect to the database")

    cur = conn.cursor()

    for i in range(0, env.subxacts - 1):
        cur.execute("SAVEPOINT s%s" % (i + 1))

    cur.execute("UPDATE pgbench_accounts SET abalance = abalance + 1 WHERE aid > 0")
    cur.execute("SAVEPOINT s%s" % env.subxacts)
    cur.execute("UPDATE pgbench_accounts SET abalance = abalance + 1 WHERE aid = %s", (int(random.random() * 100000),)
    cur.execute("ROLLBACK TO SAVEPOINT s%s" % env.subxacts)
    time.sleep(env.sleep)
    cur.execute("ROLLBACK")

if __name__ == "__main__":
    main()
