#!/bin/bash

NSUBXACT_START=0
NSUBXACT_END=128
BENCHMARK_DURATION=100
PGSQL_BIN_PATH=/usr/local/pgsql/bin

# pgbench database creation
${PGSQL_BIN_PATH}/dropdb --if-exists --maintenance-db=postgres pgbench 2>> /dev/null
${PGSQL_BIN_PATH}/createdb --maintenance-db=postgres pgbench 2>> /dev/null
${PGSQL_BIN_PATH}/pgbench -i -s 1 pgbench 2>> /dev/null

echo "nsubxacts,tps"
for ((c=${NSUBXACT_START}; c<=${NSUBXACT_END}; c=c+8))
do
    ${PGSQL_BIN_PATH}/psql pgbench -c "CHECKPOINT" > /dev/null
    python3 ./subtrans-update.py --pg "dbname=pgbench host=/tmp" --subxacts $c --sleep $((${BENCHMARK_DURATION} + 5)) > /dev/null &
    tps=$(${PGSQL_BIN_PATH}/pgbench -S -T ${BENCHMARK_DURATION} -c 48 -j 8 pgbench 2> /dev/null | grep "tps = " | sed -E "s/tps = ([0-9\.]+).*/\1/")
    echo "${c},${tps}"
    sleep 5
done
