CREATE TEMP TABLE tuplesort_test0(
    col1 int8,
    col2 numeric,
    col3 text
);

INSERT INTO tuplesort_test0(col1, col2, col3)
   SELECT generate_series(1, 30000) AS a, generate_series(1, 30000) AS b, md5(random()::text);

SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;

BEGIN;

EXPLAIN (COSTS OFF, ANALYZE)
    SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col3, col2, col1) s;

\timing on
SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col3, col2, col1) s;
\timing off

SET LOCAL work_mem = '64kB';
EXPLAIN (COSTS OFF, ANALYZE)
    SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col3, col2, col1) s;

\timing on
SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col3, col2, col1) s;
\timing off

COMMIT;