CREATE TEMP TABLE hash_index_test(
    col1 int8,
    col2 text,
    col3 timestamp
);
INSERT INTO hash_index_test(col1, col2, col3)
    SELECT a, md5(random()::text),
           make_date(2000 + a % 30, a % 12 + 1, a % 28 + 1)
        FROM generate_series(1, 25000) a;

SELECT COUNT(*) FROM hash_index_test;

CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col2);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col3);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col1);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col2);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col3);
DROP INDEX hash_index_test_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col2);
\timing off
DROP INDEX hash_index_test_ix1;
COMMIT;