CREATE TEMP TABLE hash_index_test(
    col1 numeric,
    col2 timestamp
);
INSERT INTO hash_index_test(col1, col2)
   SELECT generate_series(1, 70000) a,
   generate_series(
           (date '2000-01-01')::timestamp,
           (date '2100-12-31')::timestamp,
           interval '1 days');

SELECT COUNT(*) FROM hash_index_test;

CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col2);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col1);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col2);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col1);
DROP INDEX hash_index_test_ix1;
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col1);
DROP INDEX hash_index_test_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CREATE INDEX hash_index_test_ix1 ON hash_index_test USING HASH (col2);
\timing off
DROP INDEX hash_index_test_ix1;
COMMIT;