CREATE TEMP TABLE gist_index_test(
    col1 text,
    col2 point,
    col3 point,
    col4 point
);
INSERT INTO gist_index_test(col1, col2, col3, col4)
    SELECT md5(random()::text), point(10 - a % 10, a % 10),
           point(100 - a % 10, a % 1000), point(1000 - a % 100, a % 50)
        FROM generate_series(1, 20000) a;

SELECT COUNT(*) FROM gist_index_test;

CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col2);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col2);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col2);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col2);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col2);
DROP INDEX gist_index_test_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CREATE INDEX gist_index_test_ix1 ON gist_index_test
    USING GIST (col4, col2, col3);
\timing off
DROP INDEX gist_index_test_ix1;
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CREATE INDEX gist_index_test_ix1 ON gist_index_test
    USING GIST (col4, col2, col3);
\timing off
DROP INDEX gist_index_test_ix1;
COMMIT;