CREATE TEMP TABLE gist_index_test(
    col1 point
);
INSERT INTO gist_index_test(col1)
    SELECT (point(10 - a % 10, a % 10))
        FROM generate_series(1, 100000) a;

CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
DROP INDEX gist_index_test_ix1;
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
DROP INDEX gist_index_test_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
\timing off
DROP INDEX gist_index_test_ix1;
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CREATE INDEX gist_index_test_ix1 ON gist_index_test USING GIST (col1);
\timing off
DROP INDEX gist_index_test_ix1;
COMMIT;