CREATE TEMP TABLE btree_index_test(
    col1 text,
    col2 int8,
    col3 numeric
);
INSERT INTO btree_index_test(col1, col2, col3)
    SELECT md5(random()::text), generate_series(1, 75000) a, generate_series(1, 75000) b;

SELECT COUNT(*) FROM btree_index_test;

CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3, col2, col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3, col2, col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3, col2, col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3, col2, col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3, col2, col1);
DROP INDEX btree_index_test_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3 DESC, col2, col1);
\timing off
DROP INDEX btree_index_test_ix1;
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col3 DESC, col2, col1);
\timing off
DROP INDEX btree_index_test_ix1;
COMMIT;