CREATE TEMP TABLE btree_index_test(
    col1 text
);

CREATE OR REPLACE FUNCTION random_string(length INTEGER)
RETURNS TEXT
LANGUAGE SQL
AS $$
  select upper(
    substring(
      (SELECT string_agg(md5(random()::TEXT), '')
       FROM generate_series(
           1,
           CEIL(length / 32.)::integer)
       ), 1, length) );
$$;


INSERT INTO btree_index_test(col1)
   select random_string(15) from generate_series(1,30000);

SELECT COUNT(*) FROM btree_index_test;

CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1);
DROP INDEX btree_index_test_ix1;
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1);
DROP INDEX btree_index_test_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1 DESC);
\timing off
DROP INDEX btree_index_test_ix1;
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CREATE INDEX btree_index_test_ix1 ON btree_index_test (col1 DESC);
\timing off
DROP INDEX btree_index_test_ix1;
COMMIT;