CREATE TEMP TABLE tuplesort_test0(col1 int, col2 text);

INSERT INTO tuplesort_test0(col1, col2)
   SELECT generate_series(1, 40000) a, md5(random()::text);

SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;

BEGIN;

EXPLAIN (COSTS OFF, ANALYZE)
    SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC, col2) s;

\timing on
SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC, col2) s;
\timing off

SET LOCAL work_mem = '64kB';
EXPLAIN (COSTS OFF, ANALYZE)
    SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC, col2) s;

\timing on
SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC, col2) s;
\timing off

COMMIT;