CREATE TEMP TABLE tuplesort_test0(col1 timestamp);

INSERT INTO tuplesort_test0(col1)
    SELECT generate_series(
           (date '1800-01-01')::timestamp,
           (date '2100-12-31')::timestamp,
           interval '1 days');

SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;
SELECT COUNT(*) FROM tuplesort_test0;

BEGIN;

EXPLAIN (COSTS OFF, ANALYZE)
    SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC) s;

\timing on
SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC) s;
\timing off

SET LOCAL work_mem = '64kB';
EXPLAIN (COSTS OFF, ANALYZE)
    SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC) s;

\timing on
SELECT COUNT(*) FROM (SELECT * FROM tuplesort_test0 ORDER BY col1 DESC) s;
\timing off

COMMIT;