CREATE TEMP TABLE cluster_test0(
    col1 int PRIMARY KEY,
    col2 timestamp,
    col3 int8,
    col4 numeric
);
INSERT INTO cluster_test0(col1, col2, col3, col4)
   SELECT a, make_date(2000 + a % 30, a % 12 + 1, a % 28 + 1),
          1000 - a % 1000, 4000 - a % 4000 FROM
    generate_series(1, 50000) a;

SELECT COUNT(*) FROM cluster_test0;

CREATE INDEX cluster_test0_ix1 ON cluster_test0 (col4, col2, col3);

CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CLUSTER VERBOSE cluster_test0 USING cluster_test0_pkey;
CLUSTER VERBOSE cluster_test0 USING cluster_test0_ix1;
\timing off
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CLUSTER VERBOSE cluster_test0 USING cluster_test0_pkey;
CLUSTER VERBOSE cluster_test0 USING cluster_test0_ix1;
\timing off
COMMIT;