CREATE TEMP TABLE cluster_test0(
    col1 text PRIMARY KEY,
    col2 int8,
    col3 timestamp
);
INSERT INTO cluster_test0(col1, col2, col3)
    SELECT md5(random()::text), a,
          make_date(2000 + a % 30, a % 12 + 1, a % 28 + 1)
        FROM generate_series(1, 20000) a;

SELECT COUNT(*) FROM cluster_test0;

CREATE INDEX cluster_test0_ix1 ON cluster_test0 (col2, col3);

CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CLUSTER VERBOSE cluster_test0 USING cluster_test0_pkey;
CLUSTER VERBOSE cluster_test0 USING cluster_test0_ix1;
\timing off
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CLUSTER VERBOSE cluster_test0 USING cluster_test0_pkey;
CLUSTER VERBOSE cluster_test0 USING cluster_test0_ix1;
\timing off
COMMIT;