CREATE TEMP TABLE cluster_test0(
    col1 int PRIMARY KEY,
    col2 text
);

CREATE OR REPLACE FUNCTION random_string(length INTEGER)
RETURNS TEXT
LANGUAGE SQL
AS $$
  select upper(
    substring(
      (SELECT string_agg(md5(random()::TEXT), '')
       FROM generate_series(
           1,
           CEIL(length / 32.)::integer)
       ), 1, length) );
$$;

INSERT INTO cluster_test0(col1, col2)
   SELECT a, random_string(floor(random() * (100-50+1) + 50)::int)
    from generate_series(1,50000) a;

SELECT COUNT(*) FROM cluster_test0;

CREATE INDEX cluster_test0_ix1 ON cluster_test0 (col2);

CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;
CLUSTER cluster_test0 USING cluster_test0_pkey;
CLUSTER cluster_test0 USING cluster_test0_ix1;

BEGIN;
SET LOCAL enable_indexscan = off;
-- SET LOCAL trace_sort = true;
-- SET LOCAL client_min_messages = 'log';
\timing on
CLUSTER VERBOSE cluster_test0 USING cluster_test0_pkey;
CLUSTER VERBOSE cluster_test0 USING cluster_test0_ix1;
\timing off
SET LOCAL work_mem = '64kB';
SET LOCAL maintenance_work_mem = '1024kB';
\timing on
CLUSTER VERBOSE cluster_test0 USING cluster_test0_pkey;
CLUSTER VERBOSE cluster_test0 USING cluster_test0_ix1;
\timing off
COMMIT;