require 'gruff'

fname = ARGV[0]
title = ARGV[1]
outfname = ARGV[2]
labels = {}
data = Hash.new{|h,k| h[k]=[]}

File.readlines(fname).each do |line|
  name, conns, tps = line.strip.split(',')
  labels[conns] ||= labels.size
  data[name] << tps.to_i
end

g = Gruff::Line.new("600x400")
g.theme_pastel
g.line_width = 1
g.marker_font_size = 15
g.title = title
g.labels = labels.invert
data.each do |k,v|
  g.data k, v
end
g.write outfname
