/* decoder_stats */

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION decoder_stats" to load this file. \quit

CREATE FUNCTION decoder_stats(
OUT change_type text,
OUT change_bytes bigint,
OUT change_tuple_bytes bigint,
OUT change_cnt bigint)
RETURNS SETOF record
AS 'MODULE_PATHNAME'
LANGUAGE C STRICT VOLATILE;

CREATE FUNCTION decoder_stats_reset()
RETURNS TEXT
AS 'MODULE_PATHNAME'
LANGUAGE C STRICT VOLATILE;

CREATE FUNCTION mystats(slotname text)
RETURNS TABLE (change_type text,
	      	    change_bytes text,
		    change_tuple_bytes text,
		    change_cnt bigint,
		    change_tuple_ratio real,
		    total_bytes text,
		    total_txns bigint)  AS $$
BEGIN
    RETURN QUERY select
    ds.change_type,
    pg_size_pretty(ds.change_bytes) as change_bytes,
    pg_size_pretty(ds.change_tuple_bytes) as change_tuple_bytes,
    ds.change_cnt,
    (ds.change_tuple_bytes / ds.change_bytes::real)::real as change_tuple_ratio,
    pg_size_pretty(stats.total_bytes) as total_bytes,
    stats.total_txns
    from decoder_stats() as ds,
    (select * from pg_stat_replication_slots where slot_name = slotname) as stats
    where
    ds.change_bytes > 0;
END;
$$ LANGUAGE plpgsql;
