#ifndef EXTENDED_GRAMPARSE_H
#define EXTENDED_GRAMPARSE_H

#include "nodes/extensible.h"

#include "extended_gram.h"


/* copied from gramparse.h */ 
#ifndef GRAMPARSE_H
#define GRAMPARSE_H
/*
 * The YY_EXTRA data that a flex scanner allows us to pass around.  Private
 * state needed for raw parsing/lexing goes here.
 */
typedef struct base_yy_extra_type
{
	/*
	 * Fields used by the core scanner.
	 */
	core_yy_extra_type core_yy_extra;

	/*
	 * State variables for base_yylex().
	 */
	bool		have_lookahead; /* is lookahead info valid? */
	int			lookahead_token;	/* one-token lookahead */
	core_YYSTYPE lookahead_yylval;	/* yylval for lookahead token */
	YYLTYPE		lookahead_yylloc;	/* yylloc for lookahead token */
	char	   *lookahead_end;	/* end of current token */
	char		lookahead_hold_char;	/* to be put back at *lookahead_end */

	/*
	 * State variables that belong to the grammar.
	 */
	List	   *parsetree;		/* final parse result is delivered here */
} base_yy_extra_type;

/*
 * In principle we should use yyget_extra() to fetch the yyextra field
 * from a yyscanner struct.  However, flex always puts that field first,
 * and this is sufficiently performance-critical to make it seem worth
 * cheating a bit to use an inline macro.
 */
#define pg_yyget_extra(yyscanner) (*((base_yy_extra_type **) (yyscanner)))


/* from parser.c */
extern int	base_yylex(YYSTYPE *lvalp, YYLTYPE *llocp,
					   core_yyscan_t yyscanner);

/* from gram.y */
extern void parser_init(base_yy_extra_type *yyext);
extern int	base_yyparse(core_yyscan_t yyscanner);

#endif							/* GRAMPARSE_H */


typedef enum ExtendedSQLValueFunctionOp
{
	SVFOP_SYSDATE
} ExtendedSQLValueFunctionOp;

#define EXTENDED_NODE_TAG_START	5000
typedef enum ExtendedNodeTag
{
	T_ExtendedSQLValueFunction = EXTENDED_NODE_TAG_START, 
	T_ExtendedCreateJobStmt
} ExtendedNodeTag;

extern const char** ExtendedNodeTagNames;

typedef struct ExtendedNode
{
	ExtensibleNode extensible;
	ExtendedNodeTag extended_tag;
} ExtendedNode;

#define ExtendedNodeTag(nodeptr)		ExtendedNodeTagI((Node*) nodeptr)

static inline int
ExtendedNodeTagI(Node *node)
{
	if (!IsA(node, ExtensibleNode))
	{
		return nodeTag(node);
	}

	return ((ExtendedNode*)(node))->extended_tag;
}

#define ExtendedNewNode(size, tag) \
({	ExtendedNode   *_result; \
	AssertMacro((size) >= sizeof(ExtendedNode));		/* need the tag, at least */ \
	_result = (ExtendedNode *) palloc0fast(size); \
	_result->extensible.type = T_ExtensibleNode; \
	_result->extensible.extnodename = ExtendedNodeTagNames[tag - EXTENDED_NODE_TAG_START]; \
	_result->extended_tag =(int) (tag); \
	_result; \
})

#define ExtendedMakeNode(_type_) ((_type_ *) ExtendedNewNode(sizeof(_type_),T_##_type_))

typedef struct ExtendedSQLValueFunction
{
	ExtendedNode				expr;
	ExtendedSQLValueFunctionOp	op;		/* which function this is */
	Oid							type;			/* result type/typmod */
	int32						typmod;
	int							location;		/* token location, or -1 if unknown */
} ExtendedSQLValueFunction;

typedef struct ExtendedCreateJobStmt
{
	ExtendedNode	 node;
	char			*job_name;
	char			*schedule;
	char			*execute;
} ExtendedCreateJobStmt;



extern Node *makeExtendedSQLValueFunction(ExtendedSQLValueFunctionOp op, int32 typmod, int location);

extern int	extended_yylex(YYSTYPE *lvalp, YYLTYPE *llocp,
					   core_yyscan_t yyscanner);

extern void extended_parser_init(base_yy_extra_type *yyext);
extern int	extended_yyparse(core_yyscan_t yyscanner);

#endif							/* EXTENDED_GRAMPARSE_H */
