#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include "qsort.h"
#include <sys/time.h>

#define LARGE_SIZE 10000000
#define comp2(a,b) (*( int* )a < *( int* )b)

int comp( const void* a, const void* b ) {
    return ( *( int* )a - *( int* )b );
}

int ary[LARGE_SIZE];
int ary_mysort[LARGE_SIZE];
     
double timeval_subtract(struct timeval *x, struct timeval *y)
{
	struct timeval result;
	/* Compute the time remaining to wait. tv_usec is certainly positive. */
	result.tv_sec = x->tv_sec - y->tv_sec;
	result.tv_usec = x->tv_usec - y->tv_usec;

	/* return difference in seconds */
	return result.tv_sec + ((double) result.tv_usec / 1000000);
}

int main()
{
	struct timeval begin, end;
	int i;	
	srand(1); /* set explicit seed value */
	double secs_result;
	for(i = 0; i < LARGE_SIZE; ++i)
	{
		ary_mysort[i] = ary[i] = rand();
	}
	/* perform quick sort C using function pointer */
	gettimeofday(&begin, NULL); 
	qsort( ary, LARGE_SIZE, sizeof( int ), comp );
	gettimeofday(&end, NULL); 
 
	secs_result = timeval_subtract(&end, &begin);
	printf("C stdlib quick-sort time elapsed: %f seconds\n", secs_result);
	#define MYSORT(array,c) {                                       \
	int n = sizeof (array)/sizeof (array[0]);               \
	QSORT(typeof (array[0]),array,n,c);                     \
	}
	gettimeofday(&begin, NULL); 
	MYSORT(ary_mysort, comp2);
	gettimeofday(&end, NULL); 
	secs_result = timeval_subtract(&end, &begin);
	printf("Inline quick-sort time elapsed: %f seconds\n", secs_result);
}

