#!/usr/bin/env python3
import os
import sys
import time
import threading

class myThread (threading.Thread):
    def __init__(self, func, tuple_item, loop, loop2):
        threading.Thread.__init__(self)
        self.func = func
        self.tuple_item = tuple_item
        self.loop = loop
        self.loop2 = loop2
    def run(self): 
        self.func(self.tuple_item, self.loop, self.loop2)

def get_env(env):
    return os.getenv(env)

def output(message):
    print(message)
    sys.stdout.flush()

def debug_output(message):
    debug_enable = False
    if(debug_enable):
        output(message)

def stander_output(message):
    print(message)

def error_exit(message):
    if message:
        output(message)
    sys.exit(1)

def nomal_exit(message):
    if message:
        output(message)
    sys.exit(0)

def path_splice(path1, path2, systemtype):
    return os.path.join(path1,path2)

def file_exist(path):
    return os.path.isfile(path)

def dir_exist(path):
    return os.path.isdir(path)

def exec_comand_system(thecommand, outlog=False, report=True):
    debug_output(thecommand)
    if not outlog:
        thecommand += ' > /dev/null 2>&1'
    result=os.system(thecommand)
    if 0 != result and report:
        error_exit("Fail to run command %s" % (thecommand))

def exec_command_system_remote(thecommand, user, host, reporterror=True, outlog=False):
    if not outlog:
        thecommand += ' > /dev/null 2>&1'
    cmd = 'ssh -t -i ~/highgokey.pem %s@%s \"%s\"' % (user, host, thecommand)

    result=os.system(cmd)
    if 0 != result:
        if reporterror:
            error_exit("Fail to run command %s" % (cmd))
        else:
            return False
    return True

def dir_remote_exist(path, user, host):
    cmd = 'ls %s' % path
    retult = exec_command_system_remote(cmd, user, host, False)
    return retult

def sleep(time1):
    time.sleep(time1)

def getcwd():
    return os.getcwd()

def chdir(path):
    os.chdir(path)

def gettime():
    r = time.time()
    return r

def generate_node_conf(node_list, node_list_len, num):

    zs = int(num / node_list_len)
    ys = int(num % node_list_len)
    
    loop = 0
    file = open('node_conf', 'w')
    while loop < num:
        cur_node_num = zs
        if loop + 1 <= ys:
            cur_node_num += 1

        if loop + 1 > node_list_len:
            break

        file.write(str(node_list[loop]))
        
        file.write(' %s\n' % cur_node_num)
        loop += 1


