#!/bin/zsh

# "set -ex" appears to be a bad idea with this script, since it's prone to
# having failures that are best ignored.  pg_ctl stop seems to indicate failure
# for some reason, at times, and without apparent consequence.

SCALE=5000
TIME=7200
JOBS=`nproc`
REST="dedup_long_overnight_${SCALE}_${TIME}_SECS"

export POSTGRES_BASE="/code/postgresql"
export BUILDBRANCH="patch"
export PGPREFIX="$POSTGRES_BASE/$BUILDBRANCH/install"
export PGDATA="$POSTGRES_BASE/$BUILDBRANCH/data"
export BEGAN=$(date '+%Y_%m_%d__%H:%M')

mkdir ${BEGAN}_${REST}
for i in 1 2 3 4 ; do
  sudo fstrim -v /mnt/970pro
  sudo fstrim -v /
  MINCLIENTS=16
  for c in $MINCLIENTS 32 ; do
    for br in "patch" "master" ; do
    #for br in "master" "patch" ; do
      export PGDATA="/code/postgresql/$br/data"
      if test "$br" = "patch"; then
        export PGPORT=5432
      else
        export PGPORT=5555
      fi
      /code/postgresql/$br/install/bin/pg_ctl start -w -t 600 -o "--autovacuum=on --max_connections=150"
      pg_isready -t 10
      (
        cd /code/postgresql/$br || exit
        ./extensions.sh
      )
      # Don't let autovacuum from last run continue
      psql -c "SELECT pg_terminate_backend(pid) FROM pg_stat_progress_vacuum;"

      if test "$c" = $MINCLIENTS && test "$i" = 1; then
        pgbench -i -s $SCALE
        if test "$br" = "patch"; then
          psql -c "create index bloated_abalance on pgbench_accounts (abalance) with (deduplication=off);"
        else
          psql -c "create index bloated_abalance on pgbench_accounts (abalance);"
        fi
      fi

      (
        cd ${BEGAN}_${REST}
        # NB: This does a VACUUM for us
        pg_isready -t 10
        # Rate limit pgbench with `--rate=10000`
        pgbench -s $SCALE --report-latencies -c $c -j $JOBS -M prepared -T $TIME \
          -f ../tpcb.sql -P 1 2>&1 \
          | tee ${br}_${i}_run_${c}.out
        pg_isready -t 10
        TPS=$(cat "${br}_${i}_run_${c}.out" | grep 'tps =' | head -n 1)
        pushover "${br}_${i}_run_${c}.out: \"$TPS\"" "${BEGAN}_${REST}"
        psql -c "WITH aaa AS (
          SELECT count(*) AS buffer_count,
            avg(usagecount) AS avg_buffer_usg,
            pg_filenode_relation(reltablespace, relfilenode) AS relname,
            relforknumber
          FROM
            pg_buffercache
          GROUP BY
            pg_filenode_relation(reltablespace, relfilenode),
            relforknumber
          ORDER BY
            count(*) DESC)
        SELECT
          relname,
          relforknumber,
          pg_relation_size(relname) / 2^13 AS size_main_rel_fork_blocks,
          buffer_count,
          avg_buffer_usg
        FROM aaa;" >> ${br}_${i}_run_${c}_buffers.out
        if test "$br" = "patch"; then
          psql -c "CREATE EXTENSION IF NOT EXISTS amcheck;
                   SELECT
                     bt_index_check(c.oid, true),
                     c.relname,
                     c.relpages
                   FROM pg_index i
                     JOIN pg_opclass op ON i.indclass[0] = op.oid
                     JOIN pg_am am ON op.opcmethod = am.oid
                     JOIN pg_class c ON i.indexrelid = c.oid
                     JOIN pg_namespace n ON c.relnamespace = n.oid
                   WHERE am.amname = 'btree'
                     AND c.relpersistence != 't'
                     AND c.relkind = 'i' AND i.indisready AND i.indisvalid
                     ORDER BY c.relpages DESC;" > /dev/null || exit
        fi
        psql -c "CHECKPOINT;"
      )
      /code/postgresql/$br/install/bin/pg_ctl stop -t 600 -w
    done
  done
done
