-- Make sure statistics collected so far is sent before starting
SELECT pg_sleep(1);

-- We should have no so far collected statistics, since we haven't done anything yet:
SELECT schemaname,funcname,calls FROM pg_stat_transaction_user_functions ORDER BY schemaname,funcname;
SELECT schemaname,relname,seq_scan,seq_tup_read,idx_scan,idx_tup_fetch,n_tup_ins,n_tup_upd,n_tup_del,n_tup_hot_upd,n_live_tup,n_dead_tup FROM pg_stat_transaction_user_tables ORDER BY schemaname,relname;

-- Let's call some functions, which will generate some data activity...
SELECT new_user('joel','secret');
SELECT check_password('joel','secret');
SELECT new_transaction('joel', 'USD', 10000);
SELECT new_transaction('joel', 'USD', -3500);
SELECT get_account_balance('joel', 'USD');

-- And some more functions...
SELECT new_user('claes','qwerty');
SELECT check_password('claes','qwerty');
SELECT new_transaction('claes', 'EUR', 5000);
SELECT new_transaction('claes', 'EUR', -1000);
SELECT new_transaction('claes', 'EUR', 2000);
SELECT get_account_balance('claes', 'EUR');

DELETE FROM transactions WHERE transaction_id > 2;

-- What functions were called during this transaction?
SELECT schemaname,funcname,calls FROM pg_stat_transaction_user_functions ORDER BY schemaname,funcname;

-- What tables were affected by this transaction?
SELECT schemaname,relname,seq_scan,seq_tup_read,idx_scan,idx_tup_fetch,n_tup_ins,n_tup_upd,n_tup_del,n_tup_hot_upd,n_live_tup,n_dead_tup FROM pg_stat_transaction_user_tables ORDER BY schemaname,relname;
